(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    292498,       5820]
NotebookOptionsPosition[    283159,       5682]
NotebookOutlinePosition[    283553,       5698]
CellTagsIndexPosition[    283510,       5695]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{"<<", "VilTeX`"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "VilCretas`"}]}], "Input",
 CellChangeTimes->{{3.966968271457609*^9, 3.9669682779533978`*^9}, 
   3.967110658257852*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"36c03ecc-2c5c-45b5-8910-1c9922179926"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     StyleBox["\<\"\|01f680 VilTeX cargado\"\>",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontSize->16,
      FontWeight->Bold,
      FontColor->RGBColor[0, 0, 1]]},
    {
     StyleBox["\<\"\:2705 Listo para usar. Versi\[OAcute]n del \
01/10/2025.\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontWeight->Bold,
      FontColor->GrayLevel[0]]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967110800967423*^9, 
  3.9671144668375673`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"970d2ba0-abc1-4e40-b568-46f09221b3ba"],

Cell[BoxData["\<\"Mostrando editores ya detectados...\"\>"], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967110800967423*^9, 
  3.967114493981597*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"a006985d-01f4-423e-b6cd-6bb476f222aa"],

Cell[BoxData["\<\"=== EDITORES LaTeX DETECTADOS ===\"\>"], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967110800967423*^9, 
  3.967114493982276*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"0f374020-1180-49f5-bc96-17cf84641d22"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"TeXShop\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"TeXShop\"\>"}],
  SequenceForm["\[Checkmark] ", "TeXShop", " \[RightArrow] ", "TeXShop"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967110800967423*^9, 
  3.967114493982604*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"76c5e5dd-5550-48fd-918b-40f74bc0355c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"texstudio-4.8.8-osx-m1\"\>"}],
  SequenceForm[
  "\[Checkmark] ", "TeXstudio", " \[RightArrow] ", "texstudio-4.8.8-osx-m1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967110800967423*^9, 
  3.967114493982922*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"c3cecd12-8d16-486e-8950-4d42d2ce7740"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"Texifier\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"Texifier\"\>"}],
  SequenceForm["\[Checkmark] ", "Texifier", " \[RightArrow] ", "Texifier"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967110800967423*^9, 
  3.96711449398322*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"9d27b222-0ead-4516-abf9-99b0ed7178d3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"LaTeXiT\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"LaTeXiT\"\>"}],
  SequenceForm["\[Checkmark] ", "LaTeXiT", " \[RightArrow] ", "LaTeXiT"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967110800967423*^9, 
  3.9671144939835167`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"32a117ac-d871-4a54-828e-655c97c26a07"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     StyleBox["\<\"\|01f680 VilCretas cargado\"\>",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontSize->16,
      FontWeight->Bold,
      FontColor->RGBColor[0, 0, 1]]},
    {
     StyleBox["\<\"\:2705 Listo para usar. Versi\[OAcute]n del \
06/09/2025.\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontWeight->Bold,
      FontColor->GrayLevel[0]]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967110800967423*^9, 
  3.967114494051721*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"1899efea-2a93-46e2-aa96-d11cffaab766"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["7. ExportMaquinaToTikZ", "Subtitle",
 CellChangeTimes->{{3.964711967446312*^9, 3.9647120331966953`*^9}, {
   3.965828746741377*^9, 3.965828772379876*^9}, {3.966422117997758*^9, 
   3.966422160573628*^9}, {3.9664222257197533`*^9, 3.966422232684371*^9}, 
   3.9664306609167547`*^9, {3.966529856446561*^9, 3.966529858883006*^9}},
 Background->RGBColor[
  0.4, 0.6, 1, 0.33],ExpressionUUID->"e620c90a-a47e-4279-8a06-c63909917048"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "ExportMaquinaToTikZ"}]], "Input",
 CellChangeTimes->{{3.967110806644721*^9, 3.967110811529684*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"d514a4a3-d557-4ff2-84f4-b4dd4756d43d"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ExportMaquinaToTikZ[states, inputAlphabet, \
outputAlphabet, initialState, transitions, filename, opts] exporta una m\
\[AAcute]quina de estado finito como c\[OAcute]digo TikZ/LaTeX. \\n\\nPAR\
\[CapitalAAcute]METROS:\\n- states: Lista de estados de la m\[AAcute]quina \
(ej: {q0, q1, q2} o {Subscript[\[Sigma], 0], Subscript[\[Sigma], 1]})\\n- \
inputAlphabet: Lista de s\[IAcute]mbolos del alfabeto de entrada (ej: {0, 1} \
o {a, b})\\n- outputAlphabet: Lista de s\[IAcute]mbolos del alfabeto de \
salida (ej: {0, 1} o {x, y})\\n- initialState: Estado inicial (debe estar en \
la lista de estados)\\n- transitions: Lista de transiciones con formato \
{estadoOrigen, s\[IAcute]mboloEntrada, estadoDestino, \
s\[IAcute]mboloSalida}\\n- filename: Nombre del archivo .tex a generar (debe \
terminar en '.tex')\\n\\nOPCIONES DISPONIBLES:\\n\\nVISUALIZACI\
\[CapitalOAcute]N DE ETIQUETAS:\\n- \\\"ShowLabels\\\" -> True|False: \
Muestra/oculta las etiquetas de los estados (default: True)\\n\\nTAMA\
\[CapitalNTilde]O Y GEOMETR\[CapitalIAcute]A:\\n- \\\"StateSize\\\" -> n\
\[UAcute]mero: Tama\[NTilde]o de los estados en cm (default: 0.6)\\n- \
\\\"NodeDistance\\\" -> n\[UAcute]mero: Distancia entre nodos en cm (default: \
3)\\n\\nCOLORES DE ESTADOS:\\n- \\\"StateColor\\\" -> \\\"white\\\"|\\\"red\\\
\"|\\\"blue\\\"|\\\"lightblue\\\"|\\\"lightgreen\\\"|etc.: Color de relleno \
de estados normales (default: \\\"white\\\")\\n- \\\"AutoColor\\\" -> \
True|False: Asigna autom\[AAcute]ticamente colores diferentes a cada estado \
(default: False)\\n\\nESTILO DE TRANSICIONES:\\n- \\\"ArrowThickness\\\" -> \
True|False: Grosor de la flecha inicial. True aplica \\\"ultra thick\\\", \
False usa grosor por defecto (default: False)\\n- \\\"TransitionColor\\\" -> \
color: Color de las transiciones (default: \\\"black\\\")\\n\\nLAYOUT Y \
POSICIONAMIENTO:\\n- \\\"LayoutStyle\\\" -> \
\\\"circular\\\"|\\\"grid\\\"|\\\"spring\\\": Estilo de disposici\[OAcute]n \
autom\[AAcute]tica (default: \\\"circular\\\")\\n  * \\\"circular\\\": \
Dispone estados en c\[IAcute]rculo\\n  * \\\"grid\\\": Dispone estados en \
rejilla cuadrada ordenada\\n  * \\\"spring\\\": Disposici\[OAcute]n \
pseudoaleatoria tipo resorte\\n\\nELEMENTOS ADICIONALES:\\n- \\\"ShowGrid\\\" \
-> True|False: Muestra rejilla de coordenadas en el fondo con l\[IAcute]neas \
cada 0.5cm (default: False)\\n- \\\"ShowAxes\\\" -> True|False: Muestra ejes \
de coordenadas X/Y en color negro con flechas (default: False)\\n\\nEJEMPLOS \
DE USO:\\n\\nB\[AAcute]sico:\\nExportMaquinaToTikZ[\\n  {q0, q1}, \\n  {0, \
1}, \\n  {0, 1}, \\n  q0, \\n  {{q0, 0, q1, 1}, {q1, 1, q0, 0}}, \\n  \
\\\"maquina.tex\\\"\\n]\\n\\nCon opciones \
personalizadas:\\nExportMaquinaToTikZ[\\n  {Subscript[\[Sigma], 0], \
Subscript[\[Sigma], 1]}, \\n  {a, b}, \\n  {x, y}, \\n  Subscript[\[Sigma], \
0], \\n  {{Subscript[\[Sigma], 0], a, Subscript[\[Sigma], 1], x}}, \\n  \
\\\"automata.tex\\\",\\n  \\\"AutoColor\\\" -> True,\\n  \\\"LayoutStyle\\\" \
-> \\\"grid\\\",\\n  \\\"StateSize\\\" -> 0.8,\\n  \\\"ArrowThickness\\\" -> \
True,\\n  \\\"ShowGrid\\\" -> True,\\n  \\\"ShowAxes\\\" -> \
False\\n]\\n\\nEjemplo con todas las opciones:\\nExportMaquinaToTikZ[\\n  \
{q0, q1, q2}, \\n  {0, 1}, \\n  {0, 1}, \\n  q0, \\n  {{q0, 0, q1, 1}, {q1, \
1, q2, 0}, {q2, 0, q0, 1}}, \\n  \\\"completo.tex\\\",\\n  \\\"ShowLabels\\\" \
-> True,\\n  \\\"StateSize\\\" -> 0.8,\\n  \\\"NodeDistance\\\" -> 4,\\n  \
\\\"StateColor\\\" -> \\\"lightblue\\\",\\n  \\\"AutoColor\\\" -> False,\\n  \
\\\"ArrowThickness\\\" -> True,\\n  \\\"LayoutStyle\\\" -> \
\\\"circular\\\",\\n  \\\"TransitionColor\\\" -> \\\"purple\\\",\\n  \
\\\"ShowGrid\\\" -> True,\\n  \\\"ShowAxes\\\" -> True\\n]\\n\\nCOLORES \
SOPORTADOS:\\nColores b\[AAcute]sicos: \\\"red\\\", \\\"blue\\\", \\\"green\\\
\", \\\"orange\\\", \\\"purple\\\", \\\"brown\\\", \\\"pink\\\", \
\\\"cyan\\\", \\\"magenta\\\", \\\"yellow\\\", \\\"black\\\", \\\"white\\\", \
\\\"gray\\\"\\nColores xcolor: \\\"Red\\\", \\\"Blue\\\", \\\"Green\\\", \
\\\"Violet\\\", \\\"Gray\\\", \\\"LightGray\\\", \\\"Yellow\\\", \
\\\"Emerald\\\", \\\"Turquoise\\\", \\\"Lavender\\\", \\\"Peach\\\", \
\\\"Salmon\\\", etc.\\nColores personalizados: \\\"lightblue\\\", \
\\\"lightgreen\\\", \\\"lightyellow\\\", \\\"lightgray\\\", \
\\\"darkgray\\\"\\n\\nFORMATO DE TRANSICIONES:\\nCada transici\[OAcute]n debe \
tener el formato: {estadoOrigen, s\[IAcute]mboloEntrada, estadoDestino, s\
\[IAcute]mboloSalida}\\nEjemplo: {q0, \\\"a\\\", q1, \\\"1\\\"} representa: \
desde q0, con entrada 'a', ir a q1 y producir salida '1'\\n\\nS\
\[CapitalIAcute]MBOLOS ESPECIALES SOPORTADOS:\\nLa funci\[OAcute]n convierte \
autom\[AAcute]ticamente s\[IAcute]mbolos de Mathematica a LaTeX:\\n- \
Subscript[\[Sigma], 0] -> \[Sigma]\:2080  \\n- \[Alpha], \[Beta], \[Gamma], \
\[Delta], \[CurlyEpsilon], \[Lambda], \[Mu], \[Pi], \[Theta], \[CurlyPhi], \
\[Omega] -> letras griegas correspondientes\\n- S\[IAcute]mbolos Unicode se \
convierten autom\[AAcute]ticamente\\n\\nCOMPORTAMIENTO ESPECIAL DE AUTOCOLOR:\
\\nCuando \\\"AutoColor\\\" -> True:\\n- Cada estado recibe un color \
diferente de la paleta predefinida\\n- Los colores se asignan \
c\[IAcute]clicamente si hay m\[AAcute]s estados que colores\\n- Las \
transiciones toman el color del estado origen\\n- \\\"StateColor\\\" se \
ignora para estados individuales\\n\\nSALIDA:\\nRetorna la ruta completa del \
archivo .tex generado. El archivo se guarda en \
~/Downloads/[nombreArchivo]/\\nEl archivo incluye un documento LaTeX completo \
listo para compilar.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"ExportMaquinaToTikZ", "[", 
                    
                    RowBox[{
                    "VilTeX`Private`states_", ",", 
                    "VilTeX`Private`inputAlphabet_", ",", 
                    "VilTeX`Private`outputAlphabet_", ",", 
                    "VilTeX`Private`initialState_", ",", 
                    "VilTeX`Private`transitions_", ",", 
                    "VilTeX`Private`filename_", ",", 
                    "VilTeX`Private`opts___"}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", ",", 
                    "VilTeX`Private`fullDocument", ",", 
                    "VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`folderName", ",", 
                    "VilTeX`Private`folderPath", ",", 
                    "VilTeX`Private`statePositions", ",", 
                    RowBox[{"VilTeX`Private`showLabels", "=", "True"}], ",", 
                    RowBox[{"VilTeX`Private`stateSize", "=", "0.6`"}], ",", 
                    RowBox[{"VilTeX`Private`nodeDistance", "=", "3"}], ",", 
                    RowBox[{"VilTeX`Private`stateColor", "=", "\"white\""}], 
                    ",", 
                    RowBox[{"VilTeX`Private`autoColor", "=", "False"}], ",", 
                    RowBox[{"VilTeX`Private`arrowThickness", "=", "False"}], 
                    ",", 
                    
                    RowBox[{"VilTeX`Private`layoutStyle", "=", 
                    "\"circular\""}], ",", 
                    
                    RowBox[{"VilTeX`Private`transitionColor", "=", 
                    "\"black\""}], ",", 
                    RowBox[{"VilTeX`Private`showAxes", "=", "False"}], ",", 
                    RowBox[{"VilTeX`Private`showGrid", "=", "False"}], ",", 
                    "VilTeX`Private`optionsList", ",", 
                    "VilTeX`Private`numStates", ",", 
                    "VilTeX`Private`gridCols", ",", "VilTeX`Private`gridRows",
                     ",", "VilTeX`Private`transitionMap", ",", 
                    "VilTeX`Private`selfLoops", ",", 
                    RowBox[{"VilTeX`Private`automaticLayout", "=", "True"}]}],
                     "}"}], ",", 
                    RowBox[{
                    RowBox[{"Clear", "[", 
                    
                    RowBox[{"VilTeX`Private`colorPalette", ",", 
                    "VilTeX`Private`stateColorMap", ",", 
                    "VilTeX`Private`formatNumMaquina", ",", 
                    "VilTeX`Private`convertSymbolToLaTeXMaquina", ",", 
                    "VilTeX`Private`cleanNodeNameMaquina", ",", 
                    "VilTeX`Private`getStateLabelMaquina"}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"ListQ", "[", "VilTeX`Private`states", "]"}]}], 
                    "||", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`states", "]"}], 
                    "\[Equal]", "0"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: Los estados deben ser una lista no \
vac\[IAcute]a.\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"ListQ", "[", "VilTeX`Private`inputAlphabet", 
                    "]"}]}], "||", 
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`inputAlphabet", 
                    "]"}], "\[Equal]", "0"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: El alfabeto de entrada debe ser una lista no \
vac\[IAcute]a.\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"ListQ", "[", "VilTeX`Private`outputAlphabet", 
                    "]"}]}], "||", 
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`outputAlphabet", 
                    "]"}], "\[Equal]", "0"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: El alfabeto de salida debe ser una lista no vac\
\[IAcute]a.\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"MemberQ", "[", 
                    
                    RowBox[{"VilTeX`Private`states", ",", 
                    "VilTeX`Private`initialState"}], "]"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    
                    "\"Error: El estado inicial debe estar en la lista de \
estados.\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"ListQ", "[", "VilTeX`Private`transitions", 
                    "]"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: Las transiciones deben ser una lista.\"", "]"}],
                     ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"StringQ", "[", "VilTeX`Private`filename", 
                    "]"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: El nombre del archivo debe ser un string.\"", 
                    "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringEndsQ", "[", 
                    RowBox[{"VilTeX`Private`filename", ",", "\".tex\""}], 
                    "]"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: El nombre del archivo debe terminar en .tex\"", 
                    "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`transitions", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"_", ",", "_", ",", "_", ",", "_"}], "}"}]}], 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Error: Transici\[OAcute]n \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`i", "]"}], "<>", 
                    "\" debe tener formato {estado_origen, \
s\[IAcute]mbolo_entrada, estado_destino, s\[IAcute]mbolo_salida}.\""}], "]"}],
                     ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"VilTeX`Private`states", ",", 
                    
                    RowBox[{"VilTeX`Private`transitions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Error: Estado origen \"", "<>", 
                    RowBox[{"ToString", "[", 
                    
                    RowBox[{"VilTeX`Private`transitions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", 
                    "\" no existe.\""}], "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"VilTeX`Private`inputAlphabet", ",", 
                    
                    RowBox[{"VilTeX`Private`transitions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "2"}], 
                    "\[RightDoubleBracket]"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Error: S\[IAcute]mbolo de entrada \"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilTeX`Private`transitions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", 
                    "\" no est\[AAcute] en el alfabeto de entrada.\""}], 
                    "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"VilTeX`Private`states", ",", 
                    
                    RowBox[{"VilTeX`Private`transitions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "3"}], 
                    "\[RightDoubleBracket]"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Error: Estado destino \"", "<>", 
                    RowBox[{"ToString", "[", 
                    
                    RowBox[{"VilTeX`Private`transitions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "3"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", 
                    "\" no existe.\""}], "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"VilTeX`Private`outputAlphabet", ",", 
                    
                    RowBox[{"VilTeX`Private`transitions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "4"}], 
                    "\[RightDoubleBracket]"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Error: S\[IAcute]mbolo de salida \"", "<>", 
                    RowBox[{"ToString", "[", 
                    
                    RowBox[{"VilTeX`Private`transitions", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "4"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", 
                    "\" no est\[AAcute] en el alfabeto de salida.\""}], "]"}],
                     ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";"}],
                     ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`transitions", 
                    "]"}]}], "}"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`optionsList", "=", 
                    RowBox[{"{", "VilTeX`Private`opts", "}"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`optionsList", 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`optionsList", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"_String", "\[Rule]", "_"}]}], "]"}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`key", "=", 
                    
                    RowBox[{"VilTeX`Private`optionsList", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"VilTeX`Private`value", "=", 
                    
                    RowBox[{"VilTeX`Private`optionsList", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "2"}], 
                    "\[RightDoubleBracket]"}]}]}], "}"}], ",", 
                    RowBox[{"Switch", "[", 
                    
                    RowBox[{"VilTeX`Private`key", ",", "\"ShowLabels\"", ",", 
                    
                    RowBox[{"VilTeX`Private`showLabels", "=", 
                    "VilTeX`Private`value"}], ",", "\"StateSize\"", ",", 
                    
                    RowBox[{"VilTeX`Private`stateSize", "=", 
                    "VilTeX`Private`value"}], ",", "\"NodeDistance\"", ",", 
                    
                    RowBox[{"VilTeX`Private`nodeDistance", "=", 
                    "VilTeX`Private`value"}], ",", "\"StateColor\"", ",", 
                    
                    RowBox[{"VilTeX`Private`stateColor", "=", 
                    "VilTeX`Private`value"}], ",", "\"AutoColor\"", ",", 
                    
                    RowBox[{"VilTeX`Private`autoColor", "=", 
                    "VilTeX`Private`value"}], ",", "\"ArrowThickness\"", ",", 
                    
                    RowBox[{"VilTeX`Private`arrowThickness", "=", 
                    "VilTeX`Private`value"}], ",", "\"LayoutStyle\"", ",", 
                    
                    RowBox[{"VilTeX`Private`layoutStyle", "=", 
                    "VilTeX`Private`value"}], ",", "\"TransitionColor\"", ",", 
                    
                    RowBox[{"VilTeX`Private`transitionColor", "=", 
                    "VilTeX`Private`value"}], ",", "\"ShowAxes\"", ",", 
                    
                    RowBox[{"VilTeX`Private`showAxes", "=", 
                    "VilTeX`Private`value"}], ",", "\"ShowGrid\"", ",", 
                    
                    RowBox[{"VilTeX`Private`showGrid", "=", 
                    "VilTeX`Private`value"}], ",", "_", ",", "Null"}], 
                    "]"}]}], "]"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`optionsList", 
                    "]"}]}], "}"}]}], "]"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`colorPalette", "=", 
                    RowBox[{"{", 
                    
                    RowBox[{"\"red\"", ",", "\"blue\"", ",", "\"green\"", ",",
                     "\"orange\"", ",", "\"purple\"", ",", "\"brown\"", ",", 
                    "\"pink\"", ",", "\"cyan\"", ",", "\"magenta\"", ",", 
                    "\"lime\"", ",", "\"olive\"", ",", "\"teal\"", ",", 
                    "\"Red\"", ",", "\"Blue\"", ",", "\"Green\"", ",", 
                    "\"Violet\"", ",", "\"Gray\"", ",", "\"LightGray\"", ",", 
                    "\"Yellow\"", ",", "\"Emerald\"", ",", "\"Turquoise\"", 
                    ",", "\"Lavender\"", ",", "\"Peach\"", ",", "\"Salmon\"", 
                    ",", "\"Aquamarine\"", ",", "\"BlueViolet\"", ",", 
                    "\"CornflowerBlue\"", ",", "\"DarkOrchid\"", ",", 
                    "\"ForestGreen\"", ",", "\"Goldenrod\"", ",", 
                    "\"IndianRed\"", ",", "\"MediumBlue\"", ",", 
                    "\"OliveDrab\"", ",", "\"RoyalBlue\"", ",", 
                    "\"SeaGreen\"", ",", "\"SkyBlue\""}], "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`stateColorMap", "=", 
                    RowBox[{"Association", "[", "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`autoColor", ",", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`colorIndex", ",", 
                    "VilTeX`Private`assignedColor"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`colorIndex", "=", 
                    RowBox[{
                    RowBox[{"Mod", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`colorPalette", 
                    "]"}]}], "]"}], "+", "1"}]}], ";", 
                    RowBox[{"VilTeX`Private`assignedColor", "=", 
                    
                    RowBox[{"VilTeX`Private`colorPalette", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`colorIndex", 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`stateColorMap", "[", 
                    
                    RowBox[{"VilTeX`Private`states", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "]"}], "=",
                     "VilTeX`Private`assignedColor"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`states", "]"}]}], 
                    "}"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`formatNumMaquina", "[", 
                    "VilTeX`Private`x_", "]"}], ":=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"NumericQ", "[", "VilTeX`Private`x", "]"}], ",", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    RowBox[{"Round", "[", 
                    RowBox[{
                    RowBox[{"N", "[", "VilTeX`Private`x", "]"}], ",", 
                    "0.001`"}], "]"}], ",", "InputForm"}], "]"}], ",", 
                    "\"0\""}], "]"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`convertSymbolToLaTeXMaquina", "[",
                     "VilTeX`Private`sym_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`symStr", ",", 
                    "VilTeX`Private`result"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`symStr", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilTeX`Private`sym", ",", "InputForm"}], "]"}]}],
                     ";", 
                    RowBox[{"VilTeX`Private`result", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"VilTeX`Private`symStr", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 0]\"", "\[Rule]", 
                    "\"\\\\sigma_0\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 1]\"", "\[Rule]", 
                    "\"\\\\sigma_1\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 2]\"", "\[Rule]", 
                    "\"\\\\sigma_2\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 3]\"", "\[Rule]", 
                    "\"\\\\sigma_3\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 4]\"", "\[Rule]", 
                    "\"\\\\sigma_4\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 5]\"", "\[Rule]", 
                    "\"\\\\sigma_5\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 6]\"", "\[Rule]", 
                    "\"\\\\sigma_6\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 7]\"", "\[Rule]", 
                    "\"\\\\sigma_7\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 8]\"", "\[Rule]", 
                    "\"\\\\sigma_8\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 9]\"", "\[Rule]", 
                    "\"\\\\sigma_9\""}]}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`result", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"VilTeX`Private`result", ",", 
                    RowBox[{
                    
                    RowBox[{"RegularExpression", "[", 
                    "\"Subscript\\\\[\\\\\\\\\\\\[([A-Za-z]+)\\\\], \
([0-9]+)\\\\]\"", "]"}], "\[RuleDelayed]", 
                    RowBox[{"\"\\\\\"", "<>", 
                    RowBox[{"ToLowerCase", "[", "\"$1\"", "]"}], "<>", 
                    "\"_$2\""}]}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`result", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"VilTeX`Private`result", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"\\\\[Sigma]\"", "\[Rule]", "\"\\\\sigma\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Alpha]\"", "\[Rule]", "\"\\\\alpha\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Beta]\"", "\[Rule]", "\"\\\\beta\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Gamma]\"", "\[Rule]", "\"\\\\gamma\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Delta]\"", "\[Rule]", "\"\\\\delta\""}], 
                    ",", 
                    RowBox[{
                    "\"\\\\[Epsilon]\"", "\[Rule]", "\"\\\\varepsilon\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Lambda]\"", "\[Rule]", "\"\\\\lambda\""}],
                     ",", 
                    RowBox[{"\"\\\\[Mu]\"", "\[Rule]", "\"\\\\mu\""}], ",", 
                    RowBox[{"\"\\\\[Pi]\"", "\[Rule]", "\"\\\\pi\""}], ",", 
                    RowBox[{"\"\\\\[Theta]\"", "\[Rule]", "\"\\\\theta\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Phi]\"", "\[Rule]", "\"\\\\phi\""}], ",", 
                    
                    RowBox[{"\"\\\\[Omega]\"", "\[Rule]", "\"\\\\omega\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Tau]\"", "\[Rule]", "\"\\\\tau\""}], ",", 
                    
                    RowBox[{"\"\\\\[Rho]\"", "\[Rule]", "\"\\\\rho\""}]}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`result", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"VilTeX`Private`result", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"\[Sigma]\"", "\[Rule]", "\"\\\\sigma\""}], ",", 
                    RowBox[{"\"\[Alpha]\"", "\[Rule]", "\"\\\\alpha\""}], ",", 
                    RowBox[{"\"\[Beta]\"", "\[Rule]", "\"\\\\beta\""}], ",", 
                    RowBox[{"\"\[Gamma]\"", "\[Rule]", "\"\\\\gamma\""}], ",", 
                    RowBox[{"\"\[Delta]\"", "\[Rule]", "\"\\\\delta\""}], ",", 
                    
                    RowBox[{"\"\[CurlyEpsilon]\"", "\[Rule]", 
                    "\"\\\\varepsilon\""}], ",", 
                    RowBox[{"\"\[Lambda]\"", "\[Rule]", "\"\\\\lambda\""}], 
                    ",", 
                    RowBox[{"\"\[Mu]\"", "\[Rule]", "\"\\\\mu\""}], ",", 
                    RowBox[{"\"\[Pi]\"", "\[Rule]", "\"\\\\pi\""}], ",", 
                    RowBox[{"\"\[Theta]\"", "\[Rule]", "\"\\\\theta\""}], ",", 
                    RowBox[{"\"\[CurlyPhi]\"", "\[Rule]", "\"\\\\phi\""}], 
                    ",", 
                    RowBox[{"\"\[Omega]\"", "\[Rule]", "\"\\\\omega\""}]}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`result", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"VilTeX`Private`result", ",", 
                    RowBox[{"\"\\\"\"", "\[Rule]", "\"\""}]}], "]"}]}], ";", 
                    "VilTeX`Private`result"}]}], "]"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`cleanNodeNameMaquina", "[", 
                    "VilTeX`Private`state_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`cleanName", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`cleanName", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilTeX`Private`state", ",", "InputForm"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`cleanName", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"VilTeX`Private`cleanName", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 0]\"", "\[Rule]", 
                    "\"sigma0\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 1]\"", "\[Rule]", 
                    "\"sigma1\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 2]\"", "\[Rule]", 
                    "\"sigma2\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 3]\"", "\[Rule]", 
                    "\"sigma3\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 4]\"", "\[Rule]", 
                    "\"sigma4\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 5]\"", "\[Rule]", 
                    "\"sigma5\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 6]\"", "\[Rule]", 
                    "\"sigma6\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 7]\"", "\[Rule]", 
                    "\"sigma7\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 8]\"", "\[Rule]", 
                    "\"sigma8\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 9]\"", "\[Rule]", 
                    "\"sigma9\""}]}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`cleanName", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"VilTeX`Private`cleanName", ",", 
                    RowBox[{
                    RowBox[{"RegularExpression", "[", 
                    "\"Subscript\\\\[\\\\\\\\\\\\[([A-Za-z]+)\\\\], \
([0-9]+)\\\\]\"", "]"}], "\[RuleDelayed]", 
                    RowBox[{
                    RowBox[{"ToLowerCase", "[", "\"$1\"", "]"}], "<>", 
                    "\"$2\""}]}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`cleanName", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"VilTeX`Private`cleanName", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"\\\\[Sigma]\"", "\[Rule]", "\"sigma\""}], ",", 
                    
                    RowBox[{"\"\\\\[Alpha]\"", "\[Rule]", "\"alpha\""}], ",", 
                    
                    RowBox[{"\"\\\\[Beta]\"", "\[Rule]", "\"beta\""}], ",", 
                    RowBox[{"\"\\\\[Gamma]\"", "\[Rule]", "\"gamma\""}], ",", 
                    
                    RowBox[{"\"\\\\[Delta]\"", "\[Rule]", "\"delta\""}], ",", 
                    
                    RowBox[{"\"\\\\[Epsilon]\"", "\[Rule]", "\"epsilon\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Lambda]\"", "\[Rule]", "\"lambda\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Mu]\"", "\[Rule]", "\"mu\""}], ",", 
                    RowBox[{"\"\\\\[Pi]\"", "\[Rule]", "\"pi\""}], ",", 
                    RowBox[{"\"\\\\[Theta]\"", "\[Rule]", "\"theta\""}], ",", 
                    
                    RowBox[{"\"\\\\[Phi]\"", "\[Rule]", "\"phi\""}], ",", 
                    RowBox[{"\"\\\\[Omega]\"", "\[Rule]", "\"omega\""}]}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`cleanName", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"VilTeX`Private`cleanName", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"\[Sigma]\"", "\[Rule]", "\"sigma\""}], ",", 
                    RowBox[{"\"\[Alpha]\"", "\[Rule]", "\"alpha\""}], ",", 
                    RowBox[{"\"\[Beta]\"", "\[Rule]", "\"beta\""}], ",", 
                    RowBox[{"\"\[Gamma]\"", "\[Rule]", "\"gamma\""}], ",", 
                    RowBox[{"\"\[Delta]\"", "\[Rule]", "\"delta\""}], ",", 
                    RowBox[{"\"\[CurlyEpsilon]\"", "\[Rule]", "\"epsilon\""}],
                     ",", 
                    RowBox[{"\"\[Lambda]\"", "\[Rule]", "\"lambda\""}], ",", 
                    RowBox[{"\"\[Mu]\"", "\[Rule]", "\"mu\""}], ",", 
                    RowBox[{"\"\[Pi]\"", "\[Rule]", "\"pi\""}], ",", 
                    RowBox[{"\"\[Theta]\"", "\[Rule]", "\"theta\""}], ",", 
                    RowBox[{"\"\[CurlyPhi]\"", "\[Rule]", "\"phi\""}], ",", 
                    RowBox[{"\"\[Omega]\"", "\[Rule]", "\"omega\""}]}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`cleanName", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"VilTeX`Private`cleanName", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"[\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\"]\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\",\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\"\\\\\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\"{\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\"}\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\"$\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\"&\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\"%\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\"#\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\"^\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\"_\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\"~\"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\" \"", "\[Rule]", "\"\""}], ",", 
                    RowBox[{"\"\\\"\"", "\[Rule]", "\"\""}]}], "}"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringMatchQ", "[", 
                    RowBox[{"VilTeX`Private`cleanName", ",", 
                    
                    RowBox[{"RegularExpression", "[", "\"^[a-zA-Z].*\"", 
                    "]"}]}], "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`cleanName", "=", 
                    RowBox[{"\"state\"", "<>", "VilTeX`Private`cleanName"}]}],
                     ",", 
                    RowBox[{"VilTeX`Private`cleanName", "=", 
                    
                    RowBox[{"\"state\"", "<>", 
                    "VilTeX`Private`cleanName"}]}]}], "]"}], ";", 
                    "VilTeX`Private`cleanName"}]}], "]"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`getStateLabelMaquina", "[", 
                    "VilTeX`Private`state_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`label", ",", 
                    "VilTeX`Private`stateStr"}], "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`showLabels", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`stateStr", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilTeX`Private`state", ",", "InputForm"}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"MatchQ", "[", 
                    RowBox[{"VilTeX`Private`state", ",", 
                    SubscriptBox["_", "_"]}], "]"}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`base", ",", 
                    "VilTeX`Private`index"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`base", "=", 
                    
                    RowBox[{"VilTeX`Private`state", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`index", "=", 
                    
                    RowBox[{"VilTeX`Private`state", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`label", "=", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\[Sigma]\""}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\\\\[Sigma]\""}]}], ",", 
                    RowBox[{"\"\\\\sigma_{\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`index", "]"}], 
                    "<>", "\"}\""}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\[Alpha]\""}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\\\\[Alpha]\""}]}], ",", 
                    RowBox[{"\"\\\\alpha_{\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`index", "]"}], 
                    "<>", "\"}\""}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\[Beta]\""}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\\\\[Beta]\""}]}], ",", 
                    RowBox[{"\"\\\\beta_{\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`index", "]"}], 
                    "<>", "\"}\""}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\[Gamma]\""}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\\\\[Gamma]\""}]}], ",", 
                    RowBox[{"\"\\\\gamma_{\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`index", "]"}], 
                    "<>", "\"}\""}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\[Delta]\""}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\\\\[Delta]\""}]}], ",", 
                    RowBox[{"\"\\\\delta_{\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`index", "]"}], 
                    "<>", "\"}\""}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\[CurlyEpsilon]\""}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\\\\[Epsilon]\""}]}], ",", 
                    RowBox[{"\"\\\\varepsilon_{\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`index", "]"}], 
                    "<>", "\"}\""}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\[Lambda]\""}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\\\\[Lambda]\""}]}], ",", 
                    RowBox[{"\"\\\\lambda_{\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`index", "]"}], 
                    "<>", "\"}\""}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\[Mu]\""}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\\\\[Mu]\""}]}], ",", 
                    RowBox[{"\"\\\\mu_{\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`index", "]"}], 
                    "<>", "\"}\""}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\[Pi]\""}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\\\\[Pi]\""}]}], ",", 
                    RowBox[{"\"\\\\pi_{\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`index", "]"}], 
                    "<>", "\"}\""}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\[Theta]\""}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\\\\[Theta]\""}]}], ",", 
                    RowBox[{"\"\\\\theta_{\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`index", "]"}], 
                    "<>", "\"}\""}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\[CurlyPhi]\""}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\\\\[Phi]\""}]}], ",", 
                    RowBox[{"\"\\\\phi_{\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`index", "]"}], 
                    "<>", "\"}\""}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\[Omega]\""}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "===", "\"\\\\[Omega]\""}]}], ",", 
                    RowBox[{"\"\\\\omega_{\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`index", "]"}], 
                    "<>", "\"}\""}], ",", "True", ",", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`base", "]"}], 
                    "<>", "\"_{\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`index", "]"}], 
                    "<>", "\"}\""}]}], "]"}]}], ";"}]}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{"VilTeX`Private`stateStr", ",", "\"Subscript\""}],
                     "]"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`label", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"VilTeX`Private`stateStr", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 0]\"", "\[Rule]", 
                    "\"\\\\sigma_0\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 1]\"", "\[Rule]", 
                    "\"\\\\sigma_1\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 2]\"", "\[Rule]", 
                    "\"\\\\sigma_2\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 3]\"", "\[Rule]", 
                    "\"\\\\sigma_3\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 4]\"", "\[Rule]", 
                    "\"\\\\sigma_4\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Sigma], 5]\"", "\[Rule]", 
                    "\"\\\\sigma_5\""}], ",", 
                    
                    RowBox[{"\"Subscript[\[Sigma], 0]\"", "\[Rule]", 
                    "\"\\\\sigma_0\""}], ",", 
                    
                    RowBox[{"\"Subscript[\[Sigma], 1]\"", "\[Rule]", 
                    "\"\\\\sigma_1\""}], ",", 
                    
                    RowBox[{"\"Subscript[\[Sigma], 2]\"", "\[Rule]", 
                    "\"\\\\sigma_2\""}], ",", 
                    
                    RowBox[{"\"Subscript[\[Sigma], 3]\"", "\[Rule]", 
                    "\"\\\\sigma_3\""}], ",", 
                    
                    RowBox[{"\"Subscript[\[Sigma], 4]\"", "\[Rule]", 
                    "\"\\\\sigma_4\""}], ",", 
                    
                    RowBox[{"\"Subscript[\[Sigma], 5]\"", "\[Rule]", 
                    "\"\\\\sigma_5\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Alpha], 0]\"", "\[Rule]", 
                    "\"\\\\alpha_0\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Alpha], 1]\"", "\[Rule]", 
                    "\"\\\\alpha_1\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Beta], 0]\"", "\[Rule]", 
                    "\"\\\\beta_0\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Beta], 1]\"", "\[Rule]", 
                    "\"\\\\beta_1\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Gamma], 0]\"", "\[Rule]", 
                    "\"\\\\gamma_0\""}], ",", 
                    
                    RowBox[{"\"Subscript[\\\\[Gamma], 1]\"", "\[Rule]", 
                    "\"\\\\gamma_1\""}]}], "}"}]}], "]"}]}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`label", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilTeX`Private`state", "]"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"\[Sigma]\"", "\[Rule]", "\"\\\\sigma\""}], ",", 
                    RowBox[{"\"\[Alpha]\"", "\[Rule]", "\"\\\\alpha\""}], ",", 
                    RowBox[{"\"\[Beta]\"", "\[Rule]", "\"\\\\beta\""}], ",", 
                    RowBox[{"\"\[Gamma]\"", "\[Rule]", "\"\\\\gamma\""}], ",", 
                    RowBox[{"\"\[Delta]\"", "\[Rule]", "\"\\\\delta\""}], ",", 
                    
                    RowBox[{"\"\[CurlyEpsilon]\"", "\[Rule]", 
                    "\"\\\\varepsilon\""}], ",", 
                    RowBox[{"\"\[Lambda]\"", "\[Rule]", "\"\\\\lambda\""}], 
                    ",", 
                    RowBox[{"\"\[Mu]\"", "\[Rule]", "\"\\\\mu\""}], ",", 
                    RowBox[{"\"\[Pi]\"", "\[Rule]", "\"\\\\pi\""}], ",", 
                    RowBox[{"\"\[Theta]\"", "\[Rule]", "\"\\\\theta\""}], ",", 
                    RowBox[{"\"\[CurlyPhi]\"", "\[Rule]", "\"\\\\phi\""}], 
                    ",", 
                    RowBox[{"\"\[Omega]\"", "\[Rule]", "\"\\\\omega\""}], ",", 
                    RowBox[{"\"\\\\[Sigma]\"", "\[Rule]", "\"\\\\sigma\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Alpha]\"", "\[Rule]", "\"\\\\alpha\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Beta]\"", "\[Rule]", "\"\\\\beta\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Gamma]\"", "\[Rule]", "\"\\\\gamma\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Delta]\"", "\[Rule]", "\"\\\\delta\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Epsilon]\"", "\[Rule]", 
                    "\"\\\\varepsilon\""}], ",", 
                    RowBox[{"\"\\\\[Lambda]\"", "\[Rule]", "\"\\\\lambda\""}],
                     ",", 
                    RowBox[{"\"\\\\[Mu]\"", "\[Rule]", "\"\\\\mu\""}], ",", 
                    RowBox[{"\"\\\\[Pi]\"", "\[Rule]", "\"\\\\pi\""}], ",", 
                    RowBox[{"\"\\\\[Theta]\"", "\[Rule]", "\"\\\\theta\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Phi]\"", "\[Rule]", "\"\\\\phi\""}], ",", 
                    
                    RowBox[{"\"\\\\[Omega]\"", "\[Rule]", "\"\\\\omega\""}]}],
                     "}"}]}], "]"}]}], ";"}]}], "]"}]}], "]"}], ";", 
                    "VilTeX`Private`label"}], ",", "\"\""}], "]"}]}], "]"}]}],
                     ";", 
                    RowBox[{"VilTeX`Private`numStates", "=", 
                    RowBox[{"Length", "[", "VilTeX`Private`states", "]"}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`automaticLayout", ",", 
                    RowBox[{"Switch", "[", 
                    
                    RowBox[{"VilTeX`Private`layoutStyle", ",", "\"circular\"",
                     ",", 
                    RowBox[{"VilTeX`Private`statePositions", "=", 
                    RowBox[{"Association", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`states", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "\[Rule]", 
                    
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`nodeDistance", " ", 
                    RowBox[{"Cos", "[", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ")"}]}], 
                    "VilTeX`Private`numStates"], "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`nodeDistance", " ", 
                    RowBox[{"Sin", "[", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ")"}]}], 
                    "VilTeX`Private`numStates"], "]"}]}]}], "}"}]}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numStates"}], "}"}]}], "]"}], "]"}]}], 
                    ",", "\"grid\"", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`gridCols", "=", 
                    RowBox[{"Ceiling", "[", 
                    SqrtBox["VilTeX`Private`numStates"], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`gridRows", "=", 
                    RowBox[{"Ceiling", "[", 
                    FractionBox[
                    "VilTeX`Private`numStates", "VilTeX`Private`gridCols"], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`statePositions", "=", 
                    RowBox[{"Association", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`row", ",", "VilTeX`Private`col", 
                    ",", "VilTeX`Private`x", ",", "VilTeX`Private`y"}], "}"}],
                     ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`row", "=", 
                    RowBox[{"Ceiling", "[", 
                    FractionBox[
                    "VilTeX`Private`i", "VilTeX`Private`gridCols"], "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`col", "=", 
                    RowBox[{
                    RowBox[{"Mod", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ",", 
                    "VilTeX`Private`gridCols"}], "]"}], "+", "1"}]}], ";", 
                    RowBox[{"VilTeX`Private`x", "=", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`col", "-", "1"}], ")"}], " ", 
                    "VilTeX`Private`nodeDistance"}], "-", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`gridCols", "-", "1"}], ")"}], " ",
                     "VilTeX`Private`nodeDistance"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`y", "=", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`row", "-", "1"}], ")"}]}], " ", 
                    "VilTeX`Private`nodeDistance"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`gridRows", "-", "1"}], ")"}], " ",
                     "VilTeX`Private`nodeDistance"}]}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`states", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "\[Rule]", 
                    
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`x", ",", "VilTeX`Private`y"}], 
                    "}"}]}]}]}], "]"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numStates"}], "}"}]}], "]"}], "]"}]}]}], 
                    ",", "\"spring\"", ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`positions", "=", 
                    RowBox[{"RandomReal", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "VilTeX`Private`nodeDistance"}], ",", 
                    "VilTeX`Private`nodeDistance"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`numStates", ",", "2"}], "}"}]}], 
                    "]"}]}], "}"}], ",", 
                    RowBox[{"VilTeX`Private`statePositions", "=", 
                    RowBox[{"Association", "[", 
                    RowBox[{"Thread", "[", 
                    
                    RowBox[{"VilTeX`Private`states", "\[Rule]", 
                    "VilTeX`Private`positions"}], "]"}], "]"}]}]}], "]"}], 
                    ",", "_", ",", 
                    RowBox[{"VilTeX`Private`statePositions", "=", 
                    RowBox[{"Association", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`states", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "\[Rule]", 
                    
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`nodeDistance", " ", 
                    RowBox[{"Cos", "[", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ")"}]}], 
                    "VilTeX`Private`numStates"], "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`nodeDistance", " ", 
                    RowBox[{"Sin", "[", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ")"}]}], 
                    "VilTeX`Private`numStates"], "]"}]}]}], "}"}]}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numStates"}], "}"}]}], "]"}], "]"}]}]}], 
                    "]"}], ",", 
                    RowBox[{"VilTeX`Private`statePositions", "=", 
                    RowBox[{"Association", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`states", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "\[Rule]", 
                    
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`nodeDistance", " ", 
                    RowBox[{"Cos", "[", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ")"}]}], 
                    "VilTeX`Private`numStates"], "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`nodeDistance", " ", 
                    RowBox[{"Sin", "[", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ")"}]}], 
                    "VilTeX`Private`numStates"], "]"}]}]}], "}"}]}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numStates"}], "}"}]}], "]"}], "]"}]}]}], 
                    "]"}], ";", 
                    RowBox[{"VilTeX`Private`transitionMap", "=", 
                    RowBox[{"Association", "[", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`selfLoops", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`origin", ",", 
                    "VilTeX`Private`inputSymbol", ",", "VilTeX`Private`dest", 
                    ",", "VilTeX`Private`outputSymbol"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`origin", ",", 
                    "VilTeX`Private`inputSymbol", ",", "VilTeX`Private`dest", 
                    ",", "VilTeX`Private`outputSymbol"}], "}"}], "=", 
                    
                    RowBox[{"VilTeX`Private`transitions", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`key", ",", 
                    "VilTeX`Private`transitionLabel"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`transitionLabel", "=", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`convertSymbolToLaTeXMaquina", "[",
                     "VilTeX`Private`inputSymbol", "]"}], "<>", "\"/\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`convertSymbolToLaTeXMaquina", "[",
                     "VilTeX`Private`outputSymbol", "]"}]}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`origin", "===", 
                    "VilTeX`Private`dest"}], ",", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"VilTeX`Private`selfLoops", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`origin", ",", 
                    "VilTeX`Private`transitionLabel"}], "}"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`key", "=", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`origin", ",", 
                    "VilTeX`Private`dest"}], "}"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"KeyExistsQ", "[", 
                    
                    RowBox[{"VilTeX`Private`transitionMap", ",", 
                    "VilTeX`Private`key"}], "]"}], ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`transitionMap", "[", 
                    "VilTeX`Private`key", "]"}], "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`transitionMap", "[", 
                    "VilTeX`Private`key", "]"}], ",", 
                    "VilTeX`Private`transitionLabel"}], "]"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`transitionMap", "[", 
                    "VilTeX`Private`key", "]"}], "=", 
                    RowBox[{"{", "VilTeX`Private`transitionLabel", "}"}]}]}], 
                    "]"}]}]}], "]"}]}]}], "]"}]}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`transitions", 
                    "]"}]}], "}"}]}], "]"}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`selfLoopGroups", "=", 
                    RowBox[{"GroupBy", "[", 
                    RowBox[{"VilTeX`Private`selfLoops", ",", 
                    RowBox[{"First", "\[Rule]", "Last"}]}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"VilTeX`Private`selfLoops", "=", 
                    RowBox[{"KeyValueMap", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"#1", ",", "#2"}], "}"}], "&"}], ",", 
                    "VilTeX`Private`selfLoopGroups"}], "]"}]}]}], "]"}], ";", 
                    
                    
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    "\"\\\\begin{tikzpicture}[\\n\""}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"  -stealth,\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"  shorten >=1pt,\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"  auto,\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"  node distance=\"", "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`nodeDistance", 
                    "]"}], "<>", "\"cm,\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"  semithick\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"]\\n\\n\""}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`showGrid", ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`minX", ",", "VilTeX`Private`maxX",
                     ",", "VilTeX`Private`minY", ",", "VilTeX`Private`maxY", 
                    ",", "VilTeX`Private`gridRange"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`minX", ",", 
                    "VilTeX`Private`maxX"}], "}"}], "=", 
                    RowBox[{"MinMax", "[", 
                    RowBox[{
                    
                    RowBox[{"Values", "[", "VilTeX`Private`statePositions", 
                    "]"}], "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`minY", ",", 
                    "VilTeX`Private`maxY"}], "}"}], "=", 
                    RowBox[{"MinMax", "[", 
                    RowBox[{
                    
                    RowBox[{"Values", "[", "VilTeX`Private`statePositions", 
                    "]"}], "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`gridRange", "=", 
                    RowBox[{
                    RowBox[{"Max", "[", 
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`minX", "]"}], ",", 
                    RowBox[{"Abs", "[", "VilTeX`Private`maxX", "]"}], ",", 
                    RowBox[{"Abs", "[", "VilTeX`Private`minY", "]"}], ",", 
                    RowBox[{"Abs", "[", "VilTeX`Private`maxY", "]"}]}], "]"}],
                     "+", "1.5`"}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"% Rejilla de fondo\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"\\\\draw[help lines, step=0.5cm, color=gray!20] \"", 
                    "<>", "\"(-\"", "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`gridRange", 
                    "]"}], "<>", "\",-\"", "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`gridRange", 
                    "]"}], "<>", "\") grid (\"", "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`gridRange", 
                    "]"}], "<>", "\",\"", "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`gridRange", 
                    "]"}], "<>", "\");\\n\\n\""}]}], ";"}]}], "]"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`showAxes", ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`minX", ",", "VilTeX`Private`maxX",
                     ",", "VilTeX`Private`minY", ",", "VilTeX`Private`maxY", 
                    ",", "VilTeX`Private`xRange", ",", 
                    "VilTeX`Private`yRange"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`minX", ",", 
                    "VilTeX`Private`maxX"}], "}"}], "=", 
                    RowBox[{"MinMax", "[", 
                    RowBox[{
                    
                    RowBox[{"Values", "[", "VilTeX`Private`statePositions", 
                    "]"}], "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`minY", ",", 
                    "VilTeX`Private`maxY"}], "}"}], "=", 
                    RowBox[{"MinMax", "[", 
                    RowBox[{
                    
                    RowBox[{"Values", "[", "VilTeX`Private`statePositions", 
                    "]"}], "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`xRange", "=", 
                    RowBox[{
                    RowBox[{"Max", "[", 
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`minX", "]"}], ",", 
                    RowBox[{"Abs", "[", "VilTeX`Private`maxX", "]"}]}], "]"}],
                     "+", "1.5`"}]}], ";", 
                    RowBox[{"VilTeX`Private`yRange", "=", 
                    RowBox[{
                    RowBox[{"Max", "[", 
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`minY", "]"}], ",", 
                    RowBox[{"Abs", "[", "VilTeX`Private`maxY", "]"}]}], "]"}],
                     "+", "1.5`"}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"% Ejes de coordenadas\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"\\\\draw[thick, ->, color=black] (-\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`xRange", "]"}], 
                    "<>", "\",0) -- (\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`xRange", "]"}], 
                    "<>", "\",0) node[right] {$x$};\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"\\\\draw[thick, ->, color=black] (0,-\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`yRange", "]"}], 
                    "<>", "\") -- (0,\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`yRange", "]"}], 
                    "<>", "\") node[above] {$y$};\\n\\n\""}]}], ";"}]}], 
                    "]"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"% Definir estilos\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"\\\\tikzstyle{state}=[circle, draw, minimum size=\"", 
                    "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`stateSize", 
                    "]"}], "<>", "\"cm, fill=\"", "<>", 
                    "VilTeX`Private`stateColor", "<>", "\"]\\n\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"% Estados\\n\""}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`state", "=", 
                    
                    RowBox[{"VilTeX`Private`states", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}], ",", 
                    "VilTeX`Private`pos", ",", "VilTeX`Private`stateLabel", 
                    ",", "VilTeX`Private`nodeName", ",", 
                    "VilTeX`Private`currentStateColor"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`pos", "=", 
                    
                    RowBox[{"VilTeX`Private`statePositions", "[", 
                    "VilTeX`Private`state", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`nodeName", "=", 
                    
                    RowBox[{"VilTeX`Private`cleanNodeNameMaquina", "[", 
                    "VilTeX`Private`state", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`stateLabel", "=", 
                    
                    RowBox[{"VilTeX`Private`getStateLabelMaquina", "[", 
                    "VilTeX`Private`state", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`currentStateColor", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`autoColor", "&&", 
                    RowBox[{"KeyExistsQ", "[", 
                    
                    RowBox[{"VilTeX`Private`stateColorMap", ",", 
                    "VilTeX`Private`state"}], "]"}]}], ",", 
                    
                    RowBox[{"VilTeX`Private`stateColorMap", "[", 
                    "VilTeX`Private`state", "]"}], ",", 
                    "VilTeX`Private`stateColor"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"\\\\node[state, fill=\"", "<>", 
                    "VilTeX`Private`currentStateColor", "<>", "\"] (\"", "<>",
                     "VilTeX`Private`nodeName", "<>", "\") at (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumMaquina", "[", 
                    
                    RowBox[{"VilTeX`Private`pos", "\[LeftDoubleBracket]", "1",
                     "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumMaquina", "[", 
                    
                    RowBox[{"VilTeX`Private`pos", "\[LeftDoubleBracket]", "2",
                     "\[RightDoubleBracket]"}], "]"}], "<>", "\") {\""}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`showLabels", "&&", 
                    
                    RowBox[{"VilTeX`Private`stateLabel", "\[NotEqual]", 
                    "\"\""}]}], ",", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", "\"$\"", "<>", 
                    "VilTeX`Private`stateLabel", "<>", "\"$\""}]}]}], "]"}], 
                    ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    RowBox[{"VilTeX`Private`tikzCode", "<>", "\"};\\n\""}]}], 
                    ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`states", "]"}]}], 
                    "}"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    RowBox[{"VilTeX`Private`tikzCode", "<>", "\"\\n\""}]}], 
                    ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`initialPos", "=", 
                    
                    RowBox[{"VilTeX`Private`statePositions", "[", 
                    "VilTeX`Private`initialState", "]"}]}], ",", 
                    "VilTeX`Private`startPos", ",", 
                    "VilTeX`Private`initialNodeName", ",", 
                    "VilTeX`Private`thicknessStyle"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`initialNodeName", "=", 
                    
                    RowBox[{"VilTeX`Private`cleanNodeNameMaquina", "[", 
                    "VilTeX`Private`initialState", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`startPos", "=", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`initialPos", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "-", "1.5`"}], ",", 
                    
                    RowBox[{"VilTeX`Private`initialPos", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
                    "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`thicknessStyle", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`arrowThickness", "===", "True"}], 
                    ",", "\"ultra thick, \"", ",", "\"\""}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"% Flecha inicial\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", "\"\\\\draw[\"", 
                    "<>", "VilTeX`Private`thicknessStyle", "<>", 
                    "\"-stealth] (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumMaquina", "[", 
                    
                    RowBox[{"VilTeX`Private`startPos", "\[LeftDoubleBracket]",
                     "1", "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", 
                    "<>", 
                    RowBox[{"VilTeX`Private`formatNumMaquina", "[", 
                    
                    RowBox[{"VilTeX`Private`startPos", "\[LeftDoubleBracket]",
                     "2", "\[RightDoubleBracket]"}], "]"}], "<>", 
                    "\") -- (\"", "<>", "VilTeX`Private`initialNodeName", 
                    "<>", "\");\\n\\n\""}]}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`selfLoops", "]"}], 
                    ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"% Self-loops\\n\""}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`state", ",", 
                    "VilTeX`Private`labels", ",", "VilTeX`Private`labelStr", 
                    ",", "VilTeX`Private`loopDirection", ",", 
                    "VilTeX`Private`nodeName", ",", 
                    "VilTeX`Private`edgeColor"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`state", ",", 
                    "VilTeX`Private`labels"}], "}"}], "=", 
                    
                    RowBox[{"VilTeX`Private`selfLoops", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`nodeName", "=", 
                    
                    RowBox[{"VilTeX`Private`cleanNodeNameMaquina", "[", 
                    "VilTeX`Private`state", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`edgeColor", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`autoColor", "&&", 
                    RowBox[{"KeyExistsQ", "[", 
                    
                    RowBox[{"VilTeX`Private`stateColorMap", ",", 
                    "VilTeX`Private`state"}], "]"}]}], ",", 
                    
                    RowBox[{"VilTeX`Private`stateColorMap", "[", 
                    "VilTeX`Private`state", "]"}], ",", 
                    "VilTeX`Private`transitionColor"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`labelStr", "=", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{"VilTeX`Private`labels", ",", "\",\""}], "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`loopDirection", "=", 
                    RowBox[{"Switch", "[", 
                    RowBox[{
                    RowBox[{"Mod", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ",", "4"}], "]"}],
                     ",", "0", ",", "\"loop above\"", ",", "1", ",", 
                    "\"loop right\"", ",", "2", ",", "\"loop below\"", ",", 
                    "3", ",", "\"loop left\""}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", "\"\\\\path (\"",
                     "<>", "VilTeX`Private`nodeName", "<>", "\") edge [\"", 
                    "<>", "VilTeX`Private`loopDirection", "<>", "\", \"", 
                    "<>", "VilTeX`Private`edgeColor", "<>", "\"] node {$\"", 
                    "<>", "VilTeX`Private`labelStr", "<>", "\"$} (\"", "<>", 
                    "VilTeX`Private`nodeName", "<>", "\");\\n\""}]}], ";"}]}],
                     "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`selfLoops", 
                    "]"}]}], "}"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    RowBox[{"VilTeX`Private`tikzCode", "<>", "\"\\n\""}]}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`transitionMap", 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"% Transiciones\\n\""}]}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`keyList", "=", 
                    
                    RowBox[{"Keys", "[", "VilTeX`Private`transitionMap", 
                    "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`processedPairs", "=", 
                    RowBox[{"{", "}"}]}]}], "}"}], ",", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`key", ",", 
                    "VilTeX`Private`labels", ",", "VilTeX`Private`origin", 
                    ",", "VilTeX`Private`dest", ",", 
                    "VilTeX`Private`labelStr", ",", 
                    "VilTeX`Private`reversePair", ",", 
                    "VilTeX`Private`bidirectional", ",", 
                    "VilTeX`Private`curveAngle", ",", 
                    "VilTeX`Private`isFirstOfPair", ",", 
                    "VilTeX`Private`originNodeName", ",", 
                    "VilTeX`Private`destNodeName", ",", 
                    "VilTeX`Private`originEdgeColor"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`key", "=", 
                    
                    RowBox[{"VilTeX`Private`keyList", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`labels", "=", 
                    
                    RowBox[{"VilTeX`Private`transitionMap", "[", 
                    "VilTeX`Private`key", "]"}]}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`origin", ",", 
                    "VilTeX`Private`dest"}], "}"}], "=", 
                    "VilTeX`Private`key"}], ";", 
                    RowBox[{"VilTeX`Private`originNodeName", "=", 
                    
                    RowBox[{"VilTeX`Private`cleanNodeNameMaquina", "[", 
                    "VilTeX`Private`origin", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`destNodeName", "=", 
                    
                    RowBox[{"VilTeX`Private`cleanNodeNameMaquina", "[", 
                    "VilTeX`Private`dest", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`originEdgeColor", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`autoColor", "&&", 
                    RowBox[{"KeyExistsQ", "[", 
                    
                    RowBox[{"VilTeX`Private`stateColorMap", ",", 
                    "VilTeX`Private`origin"}], "]"}]}], ",", 
                    
                    RowBox[{"VilTeX`Private`stateColorMap", "[", 
                    "VilTeX`Private`origin", "]"}], ",", 
                    "VilTeX`Private`transitionColor"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`labelStr", "=", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{"VilTeX`Private`labels", ",", "\",\""}], "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`reversePair", "=", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`dest", ",", 
                    "VilTeX`Private`origin"}], "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`bidirectional", "=", 
                    RowBox[{"KeyExistsQ", "[", 
                    
                    RowBox[{"VilTeX`Private`transitionMap", ",", 
                    "VilTeX`Private`reversePair"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`isFirstOfPair", "=", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"VilTeX`Private`processedPairs", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`key", ",", 
                    "VilTeX`Private`reversePair"}], "}"}]}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"VilTeX`Private`processedPairs", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`reversePair", ",", 
                    "VilTeX`Private`key"}], "}"}]}], "]"}]}]}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", "VilTeX`Private`bidirectional"}], "||", 
                    "VilTeX`Private`isFirstOfPair"}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`originPos", ",", 
                    "VilTeX`Private`destPos", ",", "VilTeX`Private`dx", ",", 
                    "VilTeX`Private`dy", ",", "VilTeX`Private`angle", ",", 
                    RowBox[{"VilTeX`Private`baseAngle", "=", "20"}]}], "}"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`originPos", "=", 
                    
                    RowBox[{"VilTeX`Private`statePositions", "[", 
                    "VilTeX`Private`origin", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`destPos", "=", 
                    
                    RowBox[{"VilTeX`Private`statePositions", "[", 
                    "VilTeX`Private`dest", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`dx", "=", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`destPos", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "-", 
                    
                    RowBox[{"VilTeX`Private`originPos", 
                    "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`dy", "=", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`destPos", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "-", 
                    
                    RowBox[{"VilTeX`Private`originPos", 
                    "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`angle", "=", 
                    RowBox[{"If", "[", 
                    
                    RowBox[{"VilTeX`Private`bidirectional", ",", 
                    "VilTeX`Private`baseAngle", ",", 
                    FractionBox["VilTeX`Private`baseAngle", "2"]}], "]"}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`dx", "]"}], "<", 
                    "0.5`"}], ",", 
                    RowBox[{"VilTeX`Private`curveAngle", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`dy", ">", "0"}], ",", 
                    "VilTeX`Private`angle", ",", 
                    RowBox[{"-", "VilTeX`Private`angle"}]}], "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`dx", ">", "0"}], ",", 
                    RowBox[{"VilTeX`Private`curveAngle", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`dy", "\[GreaterEqual]", "0"}], 
                    ",", "VilTeX`Private`angle", ",", 
                    RowBox[{"-", "VilTeX`Private`angle"}]}], "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`curveAngle", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`dy", "\[GreaterEqual]", "0"}], 
                    ",", 
                    RowBox[{"-", "VilTeX`Private`angle"}], ",", 
                    "VilTeX`Private`angle"}], "]"}]}]}], "]"}]}], "]"}], ";", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", "\"\\\\path (\"",
                     "<>", "VilTeX`Private`originNodeName", "<>", 
                    "\") edge [bend left=\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"Abs", "[", "VilTeX`Private`curveAngle", "]"}], 
                    "]"}], "<>", "\", \"", "<>", 
                    "VilTeX`Private`originEdgeColor", "<>", 
                    "\"] node [above] {$\"", "<>", "VilTeX`Private`labelStr", 
                    "<>", "\"$} (\"", "<>", "VilTeX`Private`destNodeName", 
                    "<>", "\");\\n\""}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`bidirectional", ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`reverseLabels", ",", 
                    "VilTeX`Private`reverseLabelStr", ",", 
                    "VilTeX`Private`destEdgeColor"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`reverseLabels", "=", 
                    
                    RowBox[{"VilTeX`Private`transitionMap", "[", 
                    "VilTeX`Private`reversePair", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`reverseLabelStr", "=", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{"VilTeX`Private`reverseLabels", ",", "\",\""}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`destEdgeColor", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`autoColor", "&&", 
                    RowBox[{"KeyExistsQ", "[", 
                    
                    RowBox[{"VilTeX`Private`stateColorMap", ",", 
                    "VilTeX`Private`dest"}], "]"}]}], ",", 
                    
                    RowBox[{"VilTeX`Private`stateColorMap", "[", 
                    "VilTeX`Private`dest", "]"}], ",", 
                    "VilTeX`Private`transitionColor"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", "\"\\\\path (\"",
                     "<>", "VilTeX`Private`destNodeName", "<>", 
                    "\") edge [bend left=\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"Abs", "[", "VilTeX`Private`curveAngle", "]"}], 
                    "]"}], "<>", "\", \"", "<>", 
                    "VilTeX`Private`destEdgeColor", "<>", 
                    "\"] node [below] {$\"", "<>", 
                    "VilTeX`Private`reverseLabelStr", "<>", "\"$} (\"", "<>", 
                    "VilTeX`Private`originNodeName", "<>", "\");\\n\""}]}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"VilTeX`Private`processedPairs", ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`key", ",", 
                    "VilTeX`Private`reversePair"}], "}"}]}], "]"}], ";"}]}], 
                    "]"}]}]}], "]"}]}], "]"}]}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`keyList", "]"}]}], 
                    "}"}]}], "]"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"\\\\end{tikzpicture}\""}]}], ";", 
                    RowBox[{"VilTeX`Private`fullDocument", "=", 
                    
                    RowBox[{
                    "\"\\\\documentclass[border=5mm]{standalone}\\n\"", "<>", 
                    "\"\\\\usepackage{tikz}\\n\"", "<>", 
                    "\"\\\\usepackage[dvipsnames]{xcolor}\\n\"", "<>", 
                    "\"\\\\usetikzlibrary{automata, positioning, \
arrows}\\n\"", "<>", "\"\\\\usepackage{amsmath}\\n\"", "<>", 
                    "\"\\\\usepackage{amssymb}\\n\"", "<>", 
                    "\"\\n% Colores personalizados adicionales\\n\"", "<>", 
                    "\"\\\\definecolor{lightblue}{RGB}{173,216,230}\\n\"", 
                    "<>", "\"\\\\definecolor{lightgreen}{RGB}{144,238,144}\\n\
\"", "<>", "\"\\\\definecolor{lightyellow}{RGB}{255,255,224}\\n\"", "<>", 
                    "\"\\\\definecolor{lightgray}{RGB}{211,211,211}\\n\"", 
                    "<>", "\"\\\\definecolor{darkgray}{RGB}{169,169,169}\\n\"\
", "<>", "\"\\\\definecolor{orange}{RGB}{255,165,0}\\n\"", "<>", 
                    "\"\\\\definecolor{purple}{RGB}{128,0,128}\\n\"", "<>", 
                    "\"\\\\definecolor{pink}{RGB}{255,192,203}\\n\"", "<>", 
                    "\"\\n\\\\begin{document}\\n\"", "<>", 
                    "VilTeX`Private`tikzCode", "<>", 
                    "\"\\n\\\\end{document}\""}]}], ";", 
                    RowBox[{"VilTeX`Private`folderName", "=", 
                    
                    RowBox[{"FileBaseName", "[", "VilTeX`Private`filename", 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`folderPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"$HomeDirectory", ",", "\"Downloads\"", ",", 
                    "VilTeX`Private`folderName"}], "}"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"DirectoryQ", "[", "VilTeX`Private`folderPath", 
                    "]"}]}], ",", 
                    
                    RowBox[{"CreateDirectory", "[", 
                    "VilTeX`Private`folderPath", "]"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`downloadPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`folderPath", ",", 
                    "VilTeX`Private`filename"}], "}"}], "]"}]}], ";", 
                    RowBox[{"Export", "[", 
                    
                    RowBox[{"VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`fullDocument", ",", "\"Text\""}], "]"}], 
                    ";", "VilTeX`Private`downloadPath"}]}], "]"}]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilTeX`ExportMaquinaToTikZ\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ExportMaquinaToTikZ[states, inputAlphabet, \
outputAlphabet, initialState, transitions, filename, opts] exporta una m\
\[AAcute]quina de estado finito como c\[OAcute]digo TikZ/LaTeX. \\n\\nPAR\
\[CapitalAAcute]METROS:\\n- states: Lista de estados de la m\[AAcute]quina \
(ej: {q0, q1, q2} o {Subscript[\[Sigma], 0], Subscript[\[Sigma], 1]})\\n- \
inputAlphabet: Lista de s\[IAcute]mbolos del alfabeto de entrada (ej: {0, 1} \
o {a, b})\\n- outputAlphabet: Lista de s\[IAcute]mbolos del alfabeto de \
salida (ej: {0, 1} o {x, y})\\n- initialState: Estado inicial (debe estar en \
la lista de estados)\\n- transitions: Lista de transiciones con formato \
{estadoOrigen, s\[IAcute]mboloEntrada, estadoDestino, \
s\[IAcute]mboloSalida}\\n- filename: Nombre del archivo .tex a generar (debe \
terminar en '.tex')\\n\\nOPCIONES DISPONIBLES:\\n\\nVISUALIZACI\
\[CapitalOAcute]N DE ETIQUETAS:\\n- \\\"ShowLabels\\\" -> True|False: \
Muestra/oculta las etiquetas de los estados (default: True)\\n\\nTAMA\
\[CapitalNTilde]O Y GEOMETR\[CapitalIAcute]A:\\n- \\\"StateSize\\\" -> n\
\[UAcute]mero: Tama\[NTilde]o de los estados en cm (default: 0.6)\\n- \
\\\"NodeDistance\\\" -> n\[UAcute]mero: Distancia entre nodos en cm (default: \
3)\\n\\nCOLORES DE ESTADOS:\\n- \\\"StateColor\\\" -> \\\"white\\\"|\\\"red\\\
\"|\\\"blue\\\"|\\\"lightblue\\\"|\\\"lightgreen\\\"|etc.: Color de relleno \
de estados normales (default: \\\"white\\\")\\n- \\\"AutoColor\\\" -> \
True|False: Asigna autom\[AAcute]ticamente colores diferentes a cada estado \
(default: False)\\n\\nESTILO DE TRANSICIONES:\\n- \\\"ArrowThickness\\\" -> \
True|False: Grosor de la flecha inicial. True aplica \\\"ultra thick\\\", \
False usa grosor por defecto (default: False)\\n- \\\"TransitionColor\\\" -> \
color: Color de las transiciones (default: \\\"black\\\")\\n\\nLAYOUT Y \
POSICIONAMIENTO:\\n- \\\"LayoutStyle\\\" -> \
\\\"circular\\\"|\\\"grid\\\"|\\\"spring\\\": Estilo de disposici\[OAcute]n \
autom\[AAcute]tica (default: \\\"circular\\\")\\n  * \\\"circular\\\": \
Dispone estados en c\[IAcute]rculo\\n  * \\\"grid\\\": Dispone estados en \
rejilla cuadrada ordenada\\n  * \\\"spring\\\": Disposici\[OAcute]n \
pseudoaleatoria tipo resorte\\n\\nELEMENTOS ADICIONALES:\\n- \\\"ShowGrid\\\" \
-> True|False: Muestra rejilla de coordenadas en el fondo con l\[IAcute]neas \
cada 0.5cm (default: False)\\n- \\\"ShowAxes\\\" -> True|False: Muestra ejes \
de coordenadas X/Y en color negro con flechas (default: False)\\n\\nEJEMPLOS \
DE USO:\\n\\nB\[AAcute]sico:\\nExportMaquinaToTikZ[\\n  {q0, q1}, \\n  {0, \
1}, \\n  {0, 1}, \\n  q0, \\n  {{q0, 0, q1, 1}, {q1, 1, q0, 0}}, \\n  \
\\\"maquina.tex\\\"\\n]\\n\\nCon opciones \
personalizadas:\\nExportMaquinaToTikZ[\\n  {Subscript[\[Sigma], 0], \
Subscript[\[Sigma], 1]}, \\n  {a, b}, \\n  {x, y}, \\n  Subscript[\[Sigma], \
0], \\n  {{Subscript[\[Sigma], 0], a, Subscript[\[Sigma], 1], x}}, \\n  \
\\\"automata.tex\\\",\\n  \\\"AutoColor\\\" -> True,\\n  \\\"LayoutStyle\\\" \
-> \\\"grid\\\",\\n  \\\"StateSize\\\" -> 0.8,\\n  \\\"ArrowThickness\\\" -> \
True,\\n  \\\"ShowGrid\\\" -> True,\\n  \\\"ShowAxes\\\" -> \
False\\n]\\n\\nEjemplo con todas las opciones:\\nExportMaquinaToTikZ[\\n  \
{q0, q1, q2}, \\n  {0, 1}, \\n  {0, 1}, \\n  q0, \\n  {{q0, 0, q1, 1}, {q1, \
1, q2, 0}, {q2, 0, q0, 1}}, \\n  \\\"completo.tex\\\",\\n  \\\"ShowLabels\\\" \
-> True,\\n  \\\"StateSize\\\" -> 0.8,\\n  \\\"NodeDistance\\\" -> 4,\\n  \
\\\"StateColor\\\" -> \\\"lightblue\\\",\\n  \\\"AutoColor\\\" -> False,\\n  \
\\\"ArrowThickness\\\" -> True,\\n  \\\"LayoutStyle\\\" -> \
\\\"circular\\\",\\n  \\\"TransitionColor\\\" -> \\\"purple\\\",\\n  \
\\\"ShowGrid\\\" -> True,\\n  \\\"ShowAxes\\\" -> True\\n]\\n\\nCOLORES \
SOPORTADOS:\\nColores b\[AAcute]sicos: \\\"red\\\", \\\"blue\\\", \\\"green\\\
\", \\\"orange\\\", \\\"purple\\\", \\\"brown\\\", \\\"pink\\\", \
\\\"cyan\\\", \\\"magenta\\\", \\\"yellow\\\", \\\"black\\\", \\\"white\\\", \
\\\"gray\\\"\\nColores xcolor: \\\"Red\\\", \\\"Blue\\\", \\\"Green\\\", \
\\\"Violet\\\", \\\"Gray\\\", \\\"LightGray\\\", \\\"Yellow\\\", \
\\\"Emerald\\\", \\\"Turquoise\\\", \\\"Lavender\\\", \\\"Peach\\\", \
\\\"Salmon\\\", etc.\\nColores personalizados: \\\"lightblue\\\", \
\\\"lightgreen\\\", \\\"lightyellow\\\", \\\"lightgray\\\", \
\\\"darkgray\\\"\\n\\nFORMATO DE TRANSICIONES:\\nCada transici\[OAcute]n debe \
tener el formato: {estadoOrigen, s\[IAcute]mboloEntrada, estadoDestino, s\
\[IAcute]mboloSalida}\\nEjemplo: {q0, \\\"a\\\", q1, \\\"1\\\"} representa: \
desde q0, con entrada 'a', ir a q1 y producir salida '1'\\n\\nS\
\[CapitalIAcute]MBOLOS ESPECIALES SOPORTADOS:\\nLa funci\[OAcute]n convierte \
autom\[AAcute]ticamente s\[IAcute]mbolos de Mathematica a LaTeX:\\n- \
Subscript[\[Sigma], 0] -> \[Sigma]\:2080  \\n- \[Alpha], \[Beta], \[Gamma], \
\[Delta], \[CurlyEpsilon], \[Lambda], \[Mu], \[Pi], \[Theta], \[CurlyPhi], \
\[Omega] -> letras griegas correspondientes\\n- S\[IAcute]mbolos Unicode se \
convierten autom\[AAcute]ticamente\\n\\nCOMPORTAMIENTO ESPECIAL DE AUTOCOLOR:\
\\nCuando \\\"AutoColor\\\" -> True:\\n- Cada estado recibe un color \
diferente de la paleta predefinida\\n- Los colores se asignan \
c\[IAcute]clicamente si hay m\[AAcute]s estados que colores\\n- Las \
transiciones toman el color del estado origen\\n- \\\"StateColor\\\" se \
ignora para estados individuales\\n\\nSALIDA:\\nRetorna la ruta completa del \
archivo .tex generado. El archivo se guarda en \
~/Downloads/[nombreArchivo]/\\nEl archivo incluye un documento LaTeX completo \
listo para compilar.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}},
            ScrollPosition->{0., 0.}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "ExportMaquinaToTikZ[states, inputAlphabet, outputAlphabet, initialState, \
transitions, filename, opts] exporta una m\[AAcute]quina de estado finito \
como c\[OAcute]digo TikZ/LaTeX. \n\nPAR\[CapitalAAcute]METROS:\n- states: \
Lista de estados de la m\[AAcute]quina (ej: {q0, q1, q2} o \
{Subscript[\[Sigma], 0], Subscript[\[Sigma], 1]})\n- inputAlphabet: Lista de \
s\[IAcute]mbolos del alfabeto de entrada (ej: {0, 1} o {a, b})\n- \
outputAlphabet: Lista de s\[IAcute]mbolos del alfabeto de salida (ej: {0, 1} \
o {x, y})\n- initialState: Estado inicial (debe estar en la lista de estados)\
\n- transitions: Lista de transiciones con formato {estadoOrigen, \
s\[IAcute]mboloEntrada, estadoDestino, s\[IAcute]mboloSalida}\n- filename: \
Nombre del archivo .tex a generar (debe terminar en '.tex')\n\nOPCIONES \
DISPONIBLES:\n\nVISUALIZACI\[CapitalOAcute]N DE ETIQUETAS:\n- \"ShowLabels\" \
-> True|False: Muestra/oculta las etiquetas de los estados (default: True)\n\n\
TAMA\[CapitalNTilde]O Y GEOMETR\[CapitalIAcute]A:\n- \"StateSize\" -> n\
\[UAcute]mero: Tama\[NTilde]o de los estados en cm (default: 0.6)\n- \
\"NodeDistance\" -> n\[UAcute]mero: Distancia entre nodos en cm (default: 3)\n\
\nCOLORES DE ESTADOS:\n- \"StateColor\" -> \
\"white\"|\"red\"|\"blue\"|\"lightblue\"|\"lightgreen\"|etc.: Color de \
relleno de estados normales (default: \"white\")\n- \"AutoColor\" -> \
True|False: Asigna autom\[AAcute]ticamente colores diferentes a cada estado \
(default: False)\n\nESTILO DE TRANSICIONES:\n- \"ArrowThickness\" -> \
True|False: Grosor de la flecha inicial. True aplica \"ultra thick\", False \
usa grosor por defecto (default: False)\n- \"TransitionColor\" -> color: \
Color de las transiciones (default: \"black\")\n\nLAYOUT Y POSICIONAMIENTO:\n\
- \"LayoutStyle\" -> \"circular\"|\"grid\"|\"spring\": Estilo de disposici\
\[OAcute]n autom\[AAcute]tica (default: \"circular\")\n  * \"circular\": \
Dispone estados en c\[IAcute]rculo\n  * \"grid\": Dispone estados en rejilla \
cuadrada ordenada\n  * \"spring\": Disposici\[OAcute]n pseudoaleatoria tipo \
resorte\n\nELEMENTOS ADICIONALES:\n- \"ShowGrid\" -> True|False: Muestra \
rejilla de coordenadas en el fondo con l\[IAcute]neas cada 0.5cm (default: \
False)\n- \"ShowAxes\" -> True|False: Muestra ejes de coordenadas X/Y en \
color negro con flechas (default: False)\n\nEJEMPLOS DE USO:\n\n\
B\[AAcute]sico:\nExportMaquinaToTikZ[\n  {q0, q1}, \n  {0, 1}, \n  {0, 1}, \n \
 q0, \n  {{q0, 0, q1, 1}, {q1, 1, q0, 0}}, \n  \"maquina.tex\"\n]\n\nCon \
opciones personalizadas:\nExportMaquinaToTikZ[\n  {Subscript[\[Sigma], 0], \
Subscript[\[Sigma], 1]}, \n  {a, b}, \n  {x, y}, \n  Subscript[\[Sigma], 0], \
\n  {{Subscript[\[Sigma], 0], a, Subscript[\[Sigma], 1], x}}, \n  \
\"automata.tex\",\n  \"AutoColor\" -> True,\n  \"LayoutStyle\" -> \"grid\",\n \
 \"StateSize\" -> 0.8,\n  \"ArrowThickness\" -> True,\n  \"ShowGrid\" -> \
True,\n  \"ShowAxes\" -> False\n]\n\nEjemplo con todas las opciones:\n\
ExportMaquinaToTikZ[\n  {q0, q1, q2}, \n  {0, 1}, \n  {0, 1}, \n  q0, \n  \
{{q0, 0, q1, 1}, {q1, 1, q2, 0}, {q2, 0, q0, 1}}, \n  \"completo.tex\",\n  \
\"ShowLabels\" -> True,\n  \"StateSize\" -> 0.8,\n  \"NodeDistance\" -> 4,\n  \
\"StateColor\" -> \"lightblue\",\n  \"AutoColor\" -> False,\n  \
\"ArrowThickness\" -> True,\n  \"LayoutStyle\" -> \"circular\",\n  \
\"TransitionColor\" -> \"purple\",\n  \"ShowGrid\" -> True,\n  \"ShowAxes\" \
-> True\n]\n\nCOLORES SOPORTADOS:\nColores b\[AAcute]sicos: \"red\", \
\"blue\", \"green\", \"orange\", \"purple\", \"brown\", \"pink\", \"cyan\", \
\"magenta\", \"yellow\", \"black\", \"white\", \"gray\"\nColores xcolor: \
\"Red\", \"Blue\", \"Green\", \"Violet\", \"Gray\", \"LightGray\", \
\"Yellow\", \"Emerald\", \"Turquoise\", \"Lavender\", \"Peach\", \"Salmon\", \
etc.\nColores personalizados: \"lightblue\", \"lightgreen\", \"lightyellow\", \
\"lightgray\", \"darkgray\"\n\nFORMATO DE TRANSICIONES:\nCada transici\
\[OAcute]n debe tener el formato: {estadoOrigen, s\[IAcute]mboloEntrada, \
estadoDestino, s\[IAcute]mboloSalida}\nEjemplo: {q0, \"a\", q1, \"1\"} \
representa: desde q0, con entrada 'a', ir a q1 y producir salida '1'\n\nS\
\[CapitalIAcute]MBOLOS ESPECIALES SOPORTADOS:\nLa funci\[OAcute]n convierte \
autom\[AAcute]ticamente s\[IAcute]mbolos de Mathematica a LaTeX:\n- \
Subscript[\[Sigma], 0] -> \[Sigma]\:2080  \n- \[Alpha], \[Beta], \[Gamma], \
\[Delta], \[CurlyEpsilon], \[Lambda], \[Mu], \[Pi], \[Theta], \[CurlyPhi], \
\[Omega] -> letras griegas correspondientes\n- S\[IAcute]mbolos Unicode se \
convierten autom\[AAcute]ticamente\n\nCOMPORTAMIENTO ESPECIAL DE AUTOCOLOR:\n\
Cuando \"AutoColor\" -> True:\n- Cada estado recibe un color diferente de la \
paleta predefinida\n- Los colores se asignan c\[IAcute]clicamente si hay m\
\[AAcute]s estados que colores\n- Las transiciones toman el color del estado \
origen\n- \"StateColor\" se ignora para estados individuales\n\nSALIDA:\n\
Retorna la ruta completa del archivo .tex generado. El archivo se guarda en \
~/Downloads/[nombreArchivo]/\nEl archivo incluye un documento LaTeX completo \
listo para compilar.", "Documentation" -> None, "OwnValues" -> None, 
    "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilTeX`ExportMaquinaToTikZ, {VilTeX`ExportMaquinaToTikZ[
         Pattern[VilTeX`Private`states, 
          Blank[]], 
         Pattern[VilTeX`Private`inputAlphabet, 
          Blank[]], 
         Pattern[VilTeX`Private`outputAlphabet, 
          Blank[]], 
         Pattern[VilTeX`Private`initialState, 
          Blank[]], 
         Pattern[VilTeX`Private`transitions, 
          Blank[]], 
         Pattern[VilTeX`Private`filename, 
          Blank[]], 
         Pattern[VilTeX`Private`opts, 
          BlankNullSequence[]]] :> 
       Module[{VilTeX`Private`tikzCode, VilTeX`Private`fullDocument, 
          VilTeX`Private`downloadPath, VilTeX`Private`folderName, 
          VilTeX`Private`folderPath, VilTeX`Private`statePositions, 
          VilTeX`Private`showLabels = True, VilTeX`Private`stateSize = 0.6, 
          VilTeX`Private`nodeDistance = 3, VilTeX`Private`stateColor = 
          "white", VilTeX`Private`autoColor = False, 
          VilTeX`Private`arrowThickness = False, VilTeX`Private`layoutStyle = 
          "circular", VilTeX`Private`transitionColor = "black", 
          VilTeX`Private`showAxes = False, VilTeX`Private`showGrid = False, 
          VilTeX`Private`optionsList, VilTeX`Private`numStates, 
          VilTeX`Private`gridCols, VilTeX`Private`gridRows, 
          VilTeX`Private`transitionMap, VilTeX`Private`selfLoops, 
          VilTeX`Private`automaticLayout = True}, 
         Clear[VilTeX`Private`colorPalette, VilTeX`Private`stateColorMap, 
           VilTeX`Private`formatNumMaquina, 
           VilTeX`Private`convertSymbolToLaTeXMaquina, 
           VilTeX`Private`cleanNodeNameMaquina, 
           VilTeX`Private`getStateLabelMaquina]; If[
           Or[
            Not[
             ListQ[VilTeX`Private`states]], Length[VilTeX`Private`states] == 
            0], Print[
            "Error: Los estados deben ser una lista no vac\[IAcute]a."]; 
           Return[$Failed]]; If[
           Or[
            Not[
             ListQ[VilTeX`Private`inputAlphabet]], 
            Length[VilTeX`Private`inputAlphabet] == 0], 
           Print["Error: El alfabeto de entrada debe ser una lista no vac\
\[IAcute]a."]; Return[$Failed]]; If[
           Or[
            Not[
             ListQ[VilTeX`Private`outputAlphabet]], 
            Length[VilTeX`Private`outputAlphabet] == 0], 
           Print["Error: El alfabeto de salida debe ser una lista no vac\
\[IAcute]a."]; Return[$Failed]]; If[
           Not[
            MemberQ[VilTeX`Private`states, VilTeX`Private`initialState]], 
           Print["Error: El estado inicial debe estar en la lista de \
estados."]; Return[$Failed]]; If[
           Not[
            ListQ[VilTeX`Private`transitions]], 
           Print["Error: Las transiciones deben ser una lista."]; 
           Return[$Failed]]; If[
           Not[
            StringQ[VilTeX`Private`filename]], 
           Print["Error: El nombre del archivo debe ser un string."]; 
           Return[$Failed]]; If[
           Not[
            StringEndsQ[VilTeX`Private`filename, ".tex"]], 
           Print["Error: El nombre del archivo debe terminar en .tex"]; 
           Return[$Failed]]; Do[If[
             Not[
              MatchQ[
               Part[VilTeX`Private`transitions, VilTeX`Private`i], {
                Blank[], 
                Blank[], 
                Blank[], 
                Blank[]}]], 
             Print["Error: Transici\[OAcute]n " <> ToString[VilTeX`Private`i] <> 
               " debe tener formato {estado_origen, s\[IAcute]mbolo_entrada, \
estado_destino, s\[IAcute]mbolo_salida}."]; Return[$Failed]]; If[
             Not[
              MemberQ[VilTeX`Private`states, 
               Part[VilTeX`Private`transitions, VilTeX`Private`i, 1]]], 
             Print["Error: Estado origen " <> ToString[
                 Part[VilTeX`Private`transitions, VilTeX`Private`i, 1]] <> 
               " no existe."]; Return[$Failed]]; If[
             Not[
              MemberQ[VilTeX`Private`inputAlphabet, 
               Part[VilTeX`Private`transitions, VilTeX`Private`i, 2]]], 
             Print["Error: S\[IAcute]mbolo de entrada " <> ToString[
                 Part[VilTeX`Private`transitions, VilTeX`Private`i, 2]] <> 
               " no est\[AAcute] en el alfabeto de entrada."]; 
             Return[$Failed]]; If[
             Not[
              MemberQ[VilTeX`Private`states, 
               Part[VilTeX`Private`transitions, VilTeX`Private`i, 3]]], 
             Print["Error: Estado destino " <> ToString[
                 Part[VilTeX`Private`transitions, VilTeX`Private`i, 3]] <> 
               " no existe."]; Return[$Failed]]; If[
             Not[
              MemberQ[VilTeX`Private`outputAlphabet, 
               Part[VilTeX`Private`transitions, VilTeX`Private`i, 4]]], 
             Print["Error: S\[IAcute]mbolo de salida " <> ToString[
                 Part[VilTeX`Private`transitions, VilTeX`Private`i, 4]] <> 
               " no est\[AAcute] en el alfabeto de salida."]; 
             Return[$Failed]]; Null, {VilTeX`Private`i, 
            Length[VilTeX`Private`transitions]}]; 
         VilTeX`Private`optionsList = {VilTeX`Private`opts}; 
         If[Length[VilTeX`Private`optionsList] > 0, 
           Do[
            If[
             MatchQ[
              Part[VilTeX`Private`optionsList, VilTeX`Private`i], 
              Blank[String] -> Blank[]], 
             
             Module[{VilTeX`Private`key = 
               Part[VilTeX`Private`optionsList, VilTeX`Private`i, 1], 
               VilTeX`Private`value = 
               Part[VilTeX`Private`optionsList, VilTeX`Private`i, 2]}, 
              Switch[
              VilTeX`Private`key, "ShowLabels", VilTeX`Private`showLabels = 
               VilTeX`Private`value, "StateSize", VilTeX`Private`stateSize = 
               VilTeX`Private`value, "NodeDistance", 
               VilTeX`Private`nodeDistance = VilTeX`Private`value, 
               "StateColor", VilTeX`Private`stateColor = VilTeX`Private`value,
                "AutoColor", VilTeX`Private`autoColor = VilTeX`Private`value, 
               "ArrowThickness", VilTeX`Private`arrowThickness = 
               VilTeX`Private`value, "LayoutStyle", 
               VilTeX`Private`layoutStyle = VilTeX`Private`value, 
               "TransitionColor", VilTeX`Private`transitionColor = 
               VilTeX`Private`value, "ShowAxes", VilTeX`Private`showAxes = 
               VilTeX`Private`value, "ShowGrid", VilTeX`Private`showGrid = 
               VilTeX`Private`value, 
               Blank[], Null]]], {VilTeX`Private`i, 
             Length[VilTeX`Private`optionsList]}]]; 
         VilTeX`Private`colorPalette = {
           "red", "blue", "green", "orange", "purple", "brown", "pink", 
            "cyan", "magenta", "lime", "olive", "teal", "Red", "Blue", 
            "Green", "Violet", "Gray", "LightGray", "Yellow", "Emerald", 
            "Turquoise", "Lavender", "Peach", "Salmon", "Aquamarine", 
            "BlueViolet", "CornflowerBlue", "DarkOrchid", "ForestGreen", 
            "Goldenrod", "IndianRed", "MediumBlue", "OliveDrab", "RoyalBlue", 
            "SeaGreen", "SkyBlue"}; VilTeX`Private`stateColorMap = <||>; 
         If[VilTeX`Private`autoColor, Do[
             
             Module[{VilTeX`Private`colorIndex, VilTeX`Private`assignedColor},
               VilTeX`Private`colorIndex = Mod[VilTeX`Private`i - 1, 
                  Length[VilTeX`Private`colorPalette]] + 1; 
              VilTeX`Private`assignedColor = 
               Part[VilTeX`Private`colorPalette, VilTeX`Private`colorIndex]; 
              VilTeX`Private`stateColorMap[
                 Part[VilTeX`Private`states, VilTeX`Private`i]] = 
               VilTeX`Private`assignedColor; Null], {VilTeX`Private`i, 
              Length[VilTeX`Private`states]}]; Null]; 
         VilTeX`Private`formatNumMaquina[
            Pattern[VilTeX`Private`x, 
             Blank[]]] := If[
            NumericQ[VilTeX`Private`x], 
            ToString[
             Round[
              N[VilTeX`Private`x], 0.001], InputForm], "0"]; 
         VilTeX`Private`convertSymbolToLaTeXMaquina[
            Pattern[VilTeX`Private`sym, 
             Blank[]]] := 
          Module[{VilTeX`Private`symStr, VilTeX`Private`result}, 
            VilTeX`Private`symStr = ToString[VilTeX`Private`sym, InputForm]; 
            VilTeX`Private`result = 
             StringReplace[
              VilTeX`Private`symStr, {
               "Subscript[\\[Sigma], 0]" -> "\\sigma_0", 
                "Subscript[\\[Sigma], 1]" -> "\\sigma_1", 
                "Subscript[\\[Sigma], 2]" -> "\\sigma_2", 
                "Subscript[\\[Sigma], 3]" -> "\\sigma_3", 
                "Subscript[\\[Sigma], 4]" -> "\\sigma_4", 
                "Subscript[\\[Sigma], 5]" -> "\\sigma_5", 
                "Subscript[\\[Sigma], 6]" -> "\\sigma_6", 
                "Subscript[\\[Sigma], 7]" -> "\\sigma_7", 
                "Subscript[\\[Sigma], 8]" -> "\\sigma_8", 
                "Subscript[\\[Sigma], 9]" -> "\\sigma_9"}]; 
            VilTeX`Private`result = 
             StringReplace[
              VilTeX`Private`result, 
               RegularExpression[
                "Subscript\\[\\\\\\[([A-Za-z]+)\\], ([0-9]+)\\]"] :> 
               "\\" <> ToLowerCase["$1"] <> "_$2"]; 
            VilTeX`Private`result = 
             StringReplace[
              VilTeX`Private`result, {
               "\\[Sigma]" -> "\\sigma", "\\[Alpha]" -> "\\alpha", "\\[Beta]" -> 
                "\\beta", "\\[Gamma]" -> "\\gamma", "\\[Delta]" -> "\\delta", 
                "\\[Epsilon]" -> "\\varepsilon", "\\[Lambda]" -> "\\lambda", 
                "\\[Mu]" -> "\\mu", "\\[Pi]" -> "\\pi", "\\[Theta]" -> 
                "\\theta", "\\[Phi]" -> "\\phi", "\\[Omega]" -> "\\omega", 
                "\\[Tau]" -> "\\tau", "\\[Rho]" -> "\\rho"}]; 
            VilTeX`Private`result = 
             StringReplace[
              VilTeX`Private`result, {
               "\[Sigma]" -> "\\sigma", "\[Alpha]" -> "\\alpha", "\[Beta]" -> 
                "\\beta", "\[Gamma]" -> "\\gamma", "\[Delta]" -> "\\delta", 
                "\[CurlyEpsilon]" -> "\\varepsilon", "\[Lambda]" -> 
                "\\lambda", "\[Mu]" -> "\\mu", "\[Pi]" -> "\\pi", "\[Theta]" -> 
                "\\theta", "\[CurlyPhi]" -> "\\phi", "\[Omega]" -> 
                "\\omega"}]; 
            VilTeX`Private`result = 
             StringReplace[VilTeX`Private`result, "\"" -> ""]; 
            VilTeX`Private`result]; VilTeX`Private`cleanNodeNameMaquina[
            Pattern[VilTeX`Private`state, 
             Blank[]]] := 
          Module[{VilTeX`Private`cleanName}, 
            VilTeX`Private`cleanName = 
             ToString[VilTeX`Private`state, InputForm]; 
            VilTeX`Private`cleanName = 
             StringReplace[
              VilTeX`Private`cleanName, {
               "Subscript[\\[Sigma], 0]" -> "sigma0", 
                "Subscript[\\[Sigma], 1]" -> "sigma1", 
                "Subscript[\\[Sigma], 2]" -> "sigma2", 
                "Subscript[\\[Sigma], 3]" -> "sigma3", 
                "Subscript[\\[Sigma], 4]" -> "sigma4", 
                "Subscript[\\[Sigma], 5]" -> "sigma5", 
                "Subscript[\\[Sigma], 6]" -> "sigma6", 
                "Subscript[\\[Sigma], 7]" -> "sigma7", 
                "Subscript[\\[Sigma], 8]" -> "sigma8", 
                "Subscript[\\[Sigma], 9]" -> "sigma9"}]; 
            VilTeX`Private`cleanName = 
             StringReplace[
              VilTeX`Private`cleanName, 
               RegularExpression[
                "Subscript\\[\\\\\\[([A-Za-z]+)\\], ([0-9]+)\\]"] :> 
               ToLowerCase["$1"] <> "$2"]; 
            VilTeX`Private`cleanName = 
             StringReplace[
              VilTeX`Private`cleanName, {
               "\\[Sigma]" -> "sigma", "\\[Alpha]" -> "alpha", "\\[Beta]" -> 
                "beta", "\\[Gamma]" -> "gamma", "\\[Delta]" -> "delta", 
                "\\[Epsilon]" -> "epsilon", "\\[Lambda]" -> "lambda", 
                "\\[Mu]" -> "mu", "\\[Pi]" -> "pi", "\\[Theta]" -> "theta", 
                "\\[Phi]" -> "phi", "\\[Omega]" -> "omega"}]; 
            VilTeX`Private`cleanName = 
             StringReplace[
              VilTeX`Private`cleanName, {
               "\[Sigma]" -> "sigma", "\[Alpha]" -> "alpha", "\[Beta]" -> 
                "beta", "\[Gamma]" -> "gamma", "\[Delta]" -> "delta", 
                "\[CurlyEpsilon]" -> "epsilon", "\[Lambda]" -> "lambda", 
                "\[Mu]" -> "mu", "\[Pi]" -> "pi", "\[Theta]" -> "theta", 
                "\[CurlyPhi]" -> "phi", "\[Omega]" -> "omega"}]; 
            VilTeX`Private`cleanName = 
             StringReplace[
              VilTeX`Private`cleanName, {
               "[" -> "", "]" -> "", "," -> "", "\\" -> "", "{" -> "", "}" -> 
                "", "$" -> "", "&" -> "", "%" -> "", "#" -> "", "^" -> "", 
                "_" -> "", "~" -> "", " " -> "", "\"" -> ""}]; If[
              Not[
               StringMatchQ[VilTeX`Private`cleanName, 
                RegularExpression["^[a-zA-Z].*"]]], VilTeX`Private`cleanName = 
              "state" <> VilTeX`Private`cleanName, VilTeX`Private`cleanName = 
              "state" <> VilTeX`Private`cleanName]; VilTeX`Private`cleanName]; 
         VilTeX`Private`getStateLabelMaquina[
            Pattern[VilTeX`Private`state, 
             Blank[]]] := 
          Module[{VilTeX`Private`label, VilTeX`Private`stateStr}, 
            If[
            VilTeX`Private`showLabels, 
             VilTeX`Private`stateStr = 
              ToString[VilTeX`Private`state, InputForm]; If[
               MatchQ[VilTeX`Private`state, 
                Subscript[
                 Blank[], 
                 Blank[]]], 
               
               Module[{VilTeX`Private`base, VilTeX`Private`index}, 
                VilTeX`Private`base = Part[VilTeX`Private`state, 1]; 
                VilTeX`Private`index = Part[VilTeX`Private`state, 2]; 
                VilTeX`Private`label = Which[
                   Or[
                   ToString[VilTeX`Private`base] === "\[Sigma]", 
                    ToString[VilTeX`Private`base] === "\\[Sigma]"], 
                   "\\sigma_{" <> ToString[VilTeX`Private`index] <> "}", 
                   Or[
                   ToString[VilTeX`Private`base] === "\[Alpha]", 
                    ToString[VilTeX`Private`base] === "\\[Alpha]"], 
                   "\\alpha_{" <> ToString[VilTeX`Private`index] <> "}", 
                   Or[
                   ToString[VilTeX`Private`base] === "\[Beta]", 
                    ToString[VilTeX`Private`base] === "\\[Beta]"], "\\beta_{" <> 
                   ToString[VilTeX`Private`index] <> "}", 
                   Or[
                   ToString[VilTeX`Private`base] === "\[Gamma]", 
                    ToString[VilTeX`Private`base] === "\\[Gamma]"], 
                   "\\gamma_{" <> ToString[VilTeX`Private`index] <> "}", 
                   Or[
                   ToString[VilTeX`Private`base] === "\[Delta]", 
                    ToString[VilTeX`Private`base] === "\\[Delta]"], 
                   "\\delta_{" <> ToString[VilTeX`Private`index] <> "}", 
                   Or[
                   ToString[VilTeX`Private`base] === "\[CurlyEpsilon]", 
                    ToString[VilTeX`Private`base] === "\\[Epsilon]"], 
                   "\\varepsilon_{" <> ToString[VilTeX`Private`index] <> "}", 
                   
                   Or[
                   ToString[VilTeX`Private`base] === "\[Lambda]", 
                    ToString[VilTeX`Private`base] === "\\[Lambda]"], 
                   "\\lambda_{" <> ToString[VilTeX`Private`index] <> "}", 
                   Or[
                   ToString[VilTeX`Private`base] === "\[Mu]", 
                    ToString[VilTeX`Private`base] === "\\[Mu]"], "\\mu_{" <> 
                   ToString[VilTeX`Private`index] <> "}", 
                   Or[
                   ToString[VilTeX`Private`base] === "\[Pi]", 
                    ToString[VilTeX`Private`base] === "\\[Pi]"], "\\pi_{" <> 
                   ToString[VilTeX`Private`index] <> "}", 
                   Or[
                   ToString[VilTeX`Private`base] === "\[Theta]", 
                    ToString[VilTeX`Private`base] === "\\[Theta]"], 
                   "\\theta_{" <> ToString[VilTeX`Private`index] <> "}", 
                   Or[
                   ToString[VilTeX`Private`base] === "\[CurlyPhi]", 
                    ToString[VilTeX`Private`base] === "\\[Phi]"], "\\phi_{" <> 
                   ToString[VilTeX`Private`index] <> "}", 
                   Or[
                   ToString[VilTeX`Private`base] === "\[Omega]", 
                    ToString[VilTeX`Private`base] === "\\[Omega]"], 
                   "\\omega_{" <> ToString[VilTeX`Private`index] <> "}", True,
                    ToString[VilTeX`Private`base] <> "_{" <> 
                   ToString[VilTeX`Private`index] <> "}"]; Null], 
               If[
                StringContainsQ[VilTeX`Private`stateStr, "Subscript"], 
                VilTeX`Private`label = 
                 StringReplace[
                  VilTeX`Private`stateStr, {
                   "Subscript[\\[Sigma], 0]" -> "\\sigma_0", 
                    "Subscript[\\[Sigma], 1]" -> "\\sigma_1", 
                    "Subscript[\\[Sigma], 2]" -> "\\sigma_2", 
                    "Subscript[\\[Sigma], 3]" -> "\\sigma_3", 
                    "Subscript[\\[Sigma], 4]" -> "\\sigma_4", 
                    "Subscript[\\[Sigma], 5]" -> "\\sigma_5", 
                    "Subscript[\[Sigma], 0]" -> "\\sigma_0", 
                    "Subscript[\[Sigma], 1]" -> "\\sigma_1", 
                    "Subscript[\[Sigma], 2]" -> "\\sigma_2", 
                    "Subscript[\[Sigma], 3]" -> "\\sigma_3", 
                    "Subscript[\[Sigma], 4]" -> "\\sigma_4", 
                    "Subscript[\[Sigma], 5]" -> "\\sigma_5", 
                    "Subscript[\\[Alpha], 0]" -> "\\alpha_0", 
                    "Subscript[\\[Alpha], 1]" -> "\\alpha_1", 
                    "Subscript[\\[Beta], 0]" -> "\\beta_0", 
                    "Subscript[\\[Beta], 1]" -> "\\beta_1", 
                    "Subscript[\\[Gamma], 0]" -> "\\gamma_0", 
                    "Subscript[\\[Gamma], 1]" -> "\\gamma_1"}]; Null, 
                VilTeX`Private`label = StringReplace[
                   ToString[VilTeX`Private`state], {
                   "\[Sigma]" -> "\\sigma", "\[Alpha]" -> "\\alpha", 
                    "\[Beta]" -> "\\beta", "\[Gamma]" -> "\\gamma", 
                    "\[Delta]" -> "\\delta", "\[CurlyEpsilon]" -> 
                    "\\varepsilon", "\[Lambda]" -> "\\lambda", "\[Mu]" -> 
                    "\\mu", "\[Pi]" -> "\\pi", "\[Theta]" -> "\\theta", 
                    "\[CurlyPhi]" -> "\\phi", "\[Omega]" -> "\\omega", 
                    "\\[Sigma]" -> "\\sigma", "\\[Alpha]" -> "\\alpha", 
                    "\\[Beta]" -> "\\beta", "\\[Gamma]" -> "\\gamma", 
                    "\\[Delta]" -> "\\delta", "\\[Epsilon]" -> "\\varepsilon",
                     "\\[Lambda]" -> "\\lambda", "\\[Mu]" -> "\\mu", "\\[Pi]" -> 
                    "\\pi", "\\[Theta]" -> "\\theta", "\\[Phi]" -> "\\phi", 
                    "\\[Omega]" -> "\\omega"}]; Null]]; VilTeX`Private`label, 
             ""]]; VilTeX`Private`numStates = Length[VilTeX`Private`states]; 
         If[VilTeX`Private`automaticLayout, 
           Switch[
           VilTeX`Private`layoutStyle, "circular", 
            VilTeX`Private`statePositions = <|
              Table[
              Part[VilTeX`Private`states, VilTeX`Private`i] -> {
                VilTeX`Private`nodeDistance 
                 Cos[2 Pi ((VilTeX`Private`i - 1)/VilTeX`Private`numStates)], 
                 VilTeX`Private`nodeDistance 
                 Sin[2 Pi ((VilTeX`Private`i - 1)/
                    VilTeX`Private`numStates)]}, {
               VilTeX`Private`i, VilTeX`Private`numStates}]|>, "grid", 
            VilTeX`Private`gridCols = Ceiling[
               Sqrt[VilTeX`Private`numStates]]; 
            VilTeX`Private`gridRows = 
             Ceiling[VilTeX`Private`numStates/VilTeX`Private`gridCols]; 
            VilTeX`Private`statePositions = <|
               Table[
                
                Module[{
                 VilTeX`Private`row, VilTeX`Private`col, VilTeX`Private`x, 
                  VilTeX`Private`y}, 
                 VilTeX`Private`row = 
                  Ceiling[VilTeX`Private`i/VilTeX`Private`gridCols]; 
                 VilTeX`Private`col = 
                  Mod[VilTeX`Private`i - 1, VilTeX`Private`gridCols] + 1; 
                 VilTeX`Private`x = (VilTeX`Private`col - 1) 
                    VilTeX`Private`nodeDistance - (VilTeX`Private`gridCols - 
                    1) (VilTeX`Private`nodeDistance/2); 
                 VilTeX`Private`y = (-(VilTeX`Private`row - 1)) 
                    VilTeX`Private`nodeDistance + (VilTeX`Private`gridRows - 
                    1) (VilTeX`Private`nodeDistance/2); 
                 Part[VilTeX`Private`states, VilTeX`Private`i] -> {
                   VilTeX`Private`x, VilTeX`Private`y}], {
                VilTeX`Private`i, VilTeX`Private`numStates}]|>, "spring", 
            
            Module[{VilTeX`Private`positions = 
              RandomReal[{-VilTeX`Private`nodeDistance, 
                 VilTeX`Private`nodeDistance}, {
                VilTeX`Private`numStates, 2}]}, 
             VilTeX`Private`statePositions = <|
               Thread[VilTeX`Private`states -> VilTeX`Private`positions]|>], 
            Blank[], VilTeX`Private`statePositions = <|
              Table[
              Part[VilTeX`Private`states, VilTeX`Private`i] -> {
                VilTeX`Private`nodeDistance 
                 Cos[2 Pi ((VilTeX`Private`i - 1)/VilTeX`Private`numStates)], 
                 VilTeX`Private`nodeDistance 
                 Sin[2 Pi ((VilTeX`Private`i - 1)/
                    VilTeX`Private`numStates)]}, {
               VilTeX`Private`i, VilTeX`Private`numStates}]|>], 
           VilTeX`Private`statePositions = <|
             Table[
             Part[VilTeX`Private`states, VilTeX`Private`i] -> {
               VilTeX`Private`nodeDistance 
                Cos[2 Pi ((VilTeX`Private`i - 1)/VilTeX`Private`numStates)], 
                VilTeX`Private`nodeDistance 
                Sin[2 Pi ((VilTeX`Private`i - 1)/
                   VilTeX`Private`numStates)]}, {
              VilTeX`Private`i, VilTeX`Private`numStates}]|>]; 
         VilTeX`Private`transitionMap = <||>; VilTeX`Private`selfLoops = {}; 
         Do[
           
           Module[{VilTeX`Private`origin, VilTeX`Private`inputSymbol, 
             VilTeX`Private`dest, 
             VilTeX`Private`outputSymbol}, {
              VilTeX`Private`origin, VilTeX`Private`inputSymbol, 
               VilTeX`Private`dest, VilTeX`Private`outputSymbol} = 
             Part[VilTeX`Private`transitions, VilTeX`Private`i]; 
            Module[{VilTeX`Private`key, VilTeX`Private`transitionLabel}, 
              VilTeX`Private`transitionLabel = 
               VilTeX`Private`convertSymbolToLaTeXMaquina[
                 VilTeX`Private`inputSymbol] <> "/" <> 
                VilTeX`Private`convertSymbolToLaTeXMaquina[
                 VilTeX`Private`outputSymbol]; 
              If[VilTeX`Private`origin === VilTeX`Private`dest, 
                AppendTo[
                VilTeX`Private`selfLoops, {
                 VilTeX`Private`origin, VilTeX`Private`transitionLabel}], 
                VilTeX`Private`key = {
                  VilTeX`Private`origin, VilTeX`Private`dest}; If[
                  KeyExistsQ[
                  VilTeX`Private`transitionMap, VilTeX`Private`key], 
                  VilTeX`Private`transitionMap[VilTeX`Private`key] = Append[
                    VilTeX`Private`transitionMap[VilTeX`Private`key], 
                    VilTeX`Private`transitionLabel], 
                  VilTeX`Private`transitionMap[VilTeX`Private`key] = {
                   VilTeX`Private`transitionLabel}]]]], {VilTeX`Private`i, 
            Length[VilTeX`Private`transitions]}]; 
         Module[{VilTeX`Private`selfLoopGroups = 
            GroupBy[VilTeX`Private`selfLoops, First -> Last]}, 
           VilTeX`Private`selfLoops = 
           KeyValueMap[{#, #2}& , VilTeX`Private`selfLoopGroups]]; 
         VilTeX`Private`tikzCode = "\\begin{tikzpicture}[\n"; 
         VilTeX`Private`tikzCode = VilTeX`Private`tikzCode <> "  -stealth,\n"; 
         VilTeX`Private`tikzCode = 
          VilTeX`Private`tikzCode <> "  shorten >=1pt,\n"; 
         VilTeX`Private`tikzCode = VilTeX`Private`tikzCode <> "  auto,\n"; 
         VilTeX`Private`tikzCode = 
          VilTeX`Private`tikzCode <> "  node distance=" <> 
           ToString[VilTeX`Private`nodeDistance] <> "cm,\n"; 
         VilTeX`Private`tikzCode = VilTeX`Private`tikzCode <> "  semithick\n"; 
         VilTeX`Private`tikzCode = VilTeX`Private`tikzCode <> "]\n\n"; 
         If[VilTeX`Private`showGrid, 
           
           Module[{VilTeX`Private`minX, VilTeX`Private`maxX, 
             VilTeX`Private`minY, VilTeX`Private`maxY, 
             VilTeX`Private`gridRange}, {
              VilTeX`Private`minX, VilTeX`Private`maxX} = MinMax[
               Part[
                Values[VilTeX`Private`statePositions], All, 1]]; {
              VilTeX`Private`minY, VilTeX`Private`maxY} = MinMax[
               Part[
                Values[VilTeX`Private`statePositions], All, 2]]; 
            VilTeX`Private`gridRange = Max[
                Abs[VilTeX`Private`minX], 
                Abs[VilTeX`Private`maxX], 
                Abs[VilTeX`Private`minY], 
                Abs[VilTeX`Private`maxY]] + 1.5; 
            VilTeX`Private`tikzCode = 
             VilTeX`Private`tikzCode <> "% Rejilla de fondo\n"; 
            VilTeX`Private`tikzCode = 
             VilTeX`Private`tikzCode <> 
              "\\draw[help lines, step=0.5cm, color=gray!20] " <> "(-" <> 
              ToString[VilTeX`Private`gridRange] <> ",-" <> 
              ToString[VilTeX`Private`gridRange] <> ") grid (" <> 
              ToString[VilTeX`Private`gridRange] <> "," <> 
              ToString[VilTeX`Private`gridRange] <> ");\n\n"; Null]]; 
         If[VilTeX`Private`showAxes, 
           
           Module[{VilTeX`Private`minX, VilTeX`Private`maxX, 
             VilTeX`Private`minY, VilTeX`Private`maxY, VilTeX`Private`xRange, 
             VilTeX`Private`yRange}, {
              VilTeX`Private`minX, VilTeX`Private`maxX} = MinMax[
               Part[
                Values[VilTeX`Private`statePositions], All, 1]]; {
              VilTeX`Private`minY, VilTeX`Private`maxY} = MinMax[
               Part[
                Values[VilTeX`Private`statePositions], All, 2]]; 
            VilTeX`Private`xRange = Max[
                Abs[VilTeX`Private`minX], 
                Abs[VilTeX`Private`maxX]] + 1.5; VilTeX`Private`yRange = Max[
                Abs[VilTeX`Private`minY], 
                Abs[VilTeX`Private`maxY]] + 1.5; 
            VilTeX`Private`tikzCode = 
             VilTeX`Private`tikzCode <> "% Ejes de coordenadas\n"; 
            VilTeX`Private`tikzCode = 
             VilTeX`Private`tikzCode <> "\\draw[thick, ->, color=black] (-" <> 
              ToString[VilTeX`Private`xRange] <> ",0) -- (" <> 
              ToString[VilTeX`Private`xRange] <> ",0) node[right] {$x$};\n"; 
            VilTeX`Private`tikzCode = 
             VilTeX`Private`tikzCode <> "\\draw[thick, ->, color=black] (0,-" <> 
              ToString[VilTeX`Private`yRange] <> ") -- (0," <> 
              ToString[VilTeX`Private`yRange] <> ") node[above] {$y$};\n\n"; 
            Null]]; VilTeX`Private`tikzCode = 
          VilTeX`Private`tikzCode <> "% Definir estilos\n"; 
         VilTeX`Private`tikzCode = 
          VilTeX`Private`tikzCode <> 
           "\\tikzstyle{state}=[circle, draw, minimum size=" <> 
           ToString[VilTeX`Private`stateSize] <> "cm, fill=" <> 
           VilTeX`Private`stateColor <> "]\n\n"; 
         VilTeX`Private`tikzCode = VilTeX`Private`tikzCode <> "% Estados\n"; 
         Do[
           
           Module[{VilTeX`Private`state = 
             Part[VilTeX`Private`states, VilTeX`Private`i], 
             VilTeX`Private`pos, VilTeX`Private`stateLabel, 
             VilTeX`Private`nodeName, VilTeX`Private`currentStateColor}, 
            VilTeX`Private`pos = 
             VilTeX`Private`statePositions[VilTeX`Private`state]; 
            VilTeX`Private`nodeName = 
             VilTeX`Private`cleanNodeNameMaquina[VilTeX`Private`state]; 
            VilTeX`Private`stateLabel = 
             VilTeX`Private`getStateLabelMaquina[VilTeX`Private`state]; 
            VilTeX`Private`currentStateColor = If[
               And[VilTeX`Private`autoColor, 
                KeyExistsQ[
                VilTeX`Private`stateColorMap, VilTeX`Private`state]], 
               VilTeX`Private`stateColorMap[VilTeX`Private`state], 
               VilTeX`Private`stateColor]; 
            VilTeX`Private`tikzCode = 
             VilTeX`Private`tikzCode <> "\\node[state, fill=" <> 
              VilTeX`Private`currentStateColor <> "] (" <> 
              VilTeX`Private`nodeName <> ") at (" <> 
              VilTeX`Private`formatNumMaquina[
                Part[VilTeX`Private`pos, 1]] <> "," <> 
              VilTeX`Private`formatNumMaquina[
                Part[VilTeX`Private`pos, 2]] <> ") {"; If[
              And[VilTeX`Private`showLabels, VilTeX`Private`stateLabel != ""],
               VilTeX`Private`tikzCode = 
              VilTeX`Private`tikzCode <> "$" <> VilTeX`Private`stateLabel <> 
               "$"]; VilTeX`Private`tikzCode = 
             VilTeX`Private`tikzCode <> "};\n"; Null], {VilTeX`Private`i, 
            Length[VilTeX`Private`states]}]; 
         VilTeX`Private`tikzCode = VilTeX`Private`tikzCode <> "\n"; 
         Module[{VilTeX`Private`initialPos = 
            VilTeX`Private`statePositions[VilTeX`Private`initialState], 
            VilTeX`Private`startPos, VilTeX`Private`initialNodeName, 
            VilTeX`Private`thicknessStyle}, 
           VilTeX`Private`initialNodeName = 
            VilTeX`Private`cleanNodeNameMaquina[VilTeX`Private`initialState]; 
           VilTeX`Private`startPos = {
             Part[VilTeX`Private`initialPos, 1] - 1.5, 
              Part[VilTeX`Private`initialPos, 2]}; 
           VilTeX`Private`thicknessStyle = 
            If[VilTeX`Private`arrowThickness === True, "ultra thick, ", ""]; 
           VilTeX`Private`tikzCode = 
            VilTeX`Private`tikzCode <> "% Flecha inicial\n"; 
           VilTeX`Private`tikzCode = 
            VilTeX`Private`tikzCode <> "\\draw[" <> 
             VilTeX`Private`thicknessStyle <> "-stealth] (" <> 
             VilTeX`Private`formatNumMaquina[
               Part[VilTeX`Private`startPos, 1]] <> "," <> 
             VilTeX`Private`formatNumMaquina[
               Part[VilTeX`Private`startPos, 2]] <> ") -- (" <> 
             VilTeX`Private`initialNodeName <> ");\n\n"; Null]; 
         If[Length[VilTeX`Private`selfLoops] > 0, 
           VilTeX`Private`tikzCode = 
            VilTeX`Private`tikzCode <> "% Self-loops\n"; Do[
             
             Module[{VilTeX`Private`state, VilTeX`Private`labels, 
               VilTeX`Private`labelStr, VilTeX`Private`loopDirection, 
               VilTeX`Private`nodeName, 
               VilTeX`Private`edgeColor}, {
                VilTeX`Private`state, VilTeX`Private`labels} = 
               Part[VilTeX`Private`selfLoops, VilTeX`Private`i]; 
              VilTeX`Private`nodeName = 
               VilTeX`Private`cleanNodeNameMaquina[VilTeX`Private`state]; 
              VilTeX`Private`edgeColor = If[
                 And[VilTeX`Private`autoColor, 
                  KeyExistsQ[
                  VilTeX`Private`stateColorMap, VilTeX`Private`state]], 
                 VilTeX`Private`stateColorMap[VilTeX`Private`state], 
                 VilTeX`Private`transitionColor]; 
              VilTeX`Private`labelStr = 
               StringRiffle[VilTeX`Private`labels, ","]; 
              VilTeX`Private`loopDirection = Switch[
                 Mod[VilTeX`Private`i - 1, 4], 0, "loop above", 1, 
                 "loop right", 2, "loop below", 3, "loop left"]; 
              VilTeX`Private`tikzCode = 
               VilTeX`Private`tikzCode <> "\\path (" <> 
                VilTeX`Private`nodeName <> ") edge [" <> 
                VilTeX`Private`loopDirection <> ", " <> 
                VilTeX`Private`edgeColor <> "] node {$" <> 
                VilTeX`Private`labelStr <> "$} (" <> VilTeX`Private`nodeName <> 
                ");\n"; Null], {VilTeX`Private`i, 
              Length[VilTeX`Private`selfLoops]}]; 
           VilTeX`Private`tikzCode = VilTeX`Private`tikzCode <> "\n"; Null]; 
         If[Length[VilTeX`Private`transitionMap] > 0, 
           VilTeX`Private`tikzCode = 
            VilTeX`Private`tikzCode <> "% Transiciones\n"; 
           Module[{VilTeX`Private`keyList = 
              Keys[VilTeX`Private`transitionMap], 
              VilTeX`Private`processedPairs = {}}, 
             Do[
              
              Module[{VilTeX`Private`key, VilTeX`Private`labels, 
                VilTeX`Private`origin, VilTeX`Private`dest, 
                VilTeX`Private`labelStr, VilTeX`Private`reversePair, 
                VilTeX`Private`bidirectional, VilTeX`Private`curveAngle, 
                VilTeX`Private`isFirstOfPair, VilTeX`Private`originNodeName, 
                VilTeX`Private`destNodeName, VilTeX`Private`originEdgeColor}, 
               VilTeX`Private`key = 
                Part[VilTeX`Private`keyList, VilTeX`Private`i]; 
               VilTeX`Private`labels = 
                VilTeX`Private`transitionMap[VilTeX`Private`key]; {
                 VilTeX`Private`origin, VilTeX`Private`dest} = 
                VilTeX`Private`key; 
               VilTeX`Private`originNodeName = 
                VilTeX`Private`cleanNodeNameMaquina[VilTeX`Private`origin]; 
               VilTeX`Private`destNodeName = 
                VilTeX`Private`cleanNodeNameMaquina[VilTeX`Private`dest]; 
               VilTeX`Private`originEdgeColor = If[
                  And[VilTeX`Private`autoColor, 
                   KeyExistsQ[
                   VilTeX`Private`stateColorMap, VilTeX`Private`origin]], 
                  VilTeX`Private`stateColorMap[VilTeX`Private`origin], 
                  VilTeX`Private`transitionColor]; 
               VilTeX`Private`labelStr = 
                StringRiffle[VilTeX`Private`labels, ","]; 
               VilTeX`Private`reversePair = {
                 VilTeX`Private`dest, VilTeX`Private`origin}; 
               VilTeX`Private`bidirectional = 
                KeyExistsQ[
                 VilTeX`Private`transitionMap, VilTeX`Private`reversePair]; 
               VilTeX`Private`isFirstOfPair = And[
                  Not[
                   MemberQ[
                   VilTeX`Private`processedPairs, {
                    VilTeX`Private`key, VilTeX`Private`reversePair}]], 
                  Not[
                   MemberQ[
                   VilTeX`Private`processedPairs, {
                    VilTeX`Private`reversePair, VilTeX`Private`key}]]]; If[
                 Or[
                  Not[VilTeX`Private`bidirectional], 
                  VilTeX`Private`isFirstOfPair], 
                 
                 Module[{
                  VilTeX`Private`originPos, VilTeX`Private`destPos, 
                   VilTeX`Private`dx, VilTeX`Private`dy, VilTeX`Private`angle,
                    VilTeX`Private`baseAngle = 20}, 
                  VilTeX`Private`originPos = 
                   VilTeX`Private`statePositions[VilTeX`Private`origin]; 
                  VilTeX`Private`destPos = 
                   VilTeX`Private`statePositions[VilTeX`Private`dest]; 
                  VilTeX`Private`dx = 
                   Part[VilTeX`Private`destPos, 1] - Part[
                    VilTeX`Private`originPos, 1]; 
                  VilTeX`Private`dy = 
                   Part[VilTeX`Private`destPos, 2] - Part[
                    VilTeX`Private`originPos, 2]; 
                  VilTeX`Private`angle = 
                   If[VilTeX`Private`bidirectional, VilTeX`Private`baseAngle, 
                    VilTeX`Private`baseAngle/2]; 
                  If[Abs[VilTeX`Private`dx] < 0.5, VilTeX`Private`curveAngle = 
                    If[VilTeX`Private`dy > 0, VilTeX`Private`angle, -
                    VilTeX`Private`angle], 
                    If[
                    VilTeX`Private`dx > 0, VilTeX`Private`curveAngle = 
                    If[VilTeX`Private`dy >= 0, VilTeX`Private`angle, -
                    VilTeX`Private`angle], VilTeX`Private`curveAngle = 
                    If[VilTeX`Private`dy >= 0, -VilTeX`Private`angle, 
                    VilTeX`Private`angle]]]; 
                  VilTeX`Private`tikzCode = 
                   VilTeX`Private`tikzCode <> "\\path (" <> 
                    VilTeX`Private`originNodeName <> ") edge [bend left=" <> 
                    ToString[
                    Abs[VilTeX`Private`curveAngle]] <> ", " <> 
                    VilTeX`Private`originEdgeColor <> "] node [above] {$" <> 
                    VilTeX`Private`labelStr <> "$} (" <> 
                    VilTeX`Private`destNodeName <> ");\n"; 
                  If[VilTeX`Private`bidirectional, 
                    Module[{
                    VilTeX`Private`reverseLabels, 
                    VilTeX`Private`reverseLabelStr, 
                    VilTeX`Private`destEdgeColor}, 
                    VilTeX`Private`reverseLabels = 
                    VilTeX`Private`transitionMap[VilTeX`Private`reversePair]; 
                    VilTeX`Private`reverseLabelStr = 
                    StringRiffle[VilTeX`Private`reverseLabels, ","]; 
                    VilTeX`Private`destEdgeColor = If[
                    And[VilTeX`Private`autoColor, 
                    KeyExistsQ[
                    VilTeX`Private`stateColorMap, VilTeX`Private`dest]], 
                    VilTeX`Private`stateColorMap[VilTeX`Private`dest], 
                    VilTeX`Private`transitionColor]; 
                    VilTeX`Private`tikzCode = 
                    VilTeX`Private`tikzCode <> "\\path (" <> 
                    VilTeX`Private`destNodeName <> ") edge [bend left=" <> 
                    ToString[
                    Abs[VilTeX`Private`curveAngle]] <> ", " <> 
                    VilTeX`Private`destEdgeColor <> "] node [below] {$" <> 
                    VilTeX`Private`reverseLabelStr <> "$} (" <> 
                    VilTeX`Private`originNodeName <> ");\n"; Null]; 
                    AppendTo[
                    VilTeX`Private`processedPairs, {
                    VilTeX`Private`key, VilTeX`Private`reversePair}]; 
                    Null]]]], {VilTeX`Private`i, 
               Length[VilTeX`Private`keyList]}]]; Null]; 
         VilTeX`Private`tikzCode = 
          VilTeX`Private`tikzCode <> "\\end{tikzpicture}"; 
         VilTeX`Private`fullDocument = 
          "\\documentclass[border=5mm]{standalone}\n" <> 
           "\\usepackage{tikz}\n" <> "\\usepackage[dvipsnames]{xcolor}\n" <> 
           "\\usetikzlibrary{automata, positioning, arrows}\n" <> 
           "\\usepackage{amsmath}\n" <> "\\usepackage{amssymb}\n" <> 
           "\n% Colores personalizados adicionales\n" <> 
           "\\definecolor{lightblue}{RGB}{173,216,230}\n" <> 
           "\\definecolor{lightgreen}{RGB}{144,238,144}\n" <> 
           "\\definecolor{lightyellow}{RGB}{255,255,224}\n" <> 
           "\\definecolor{lightgray}{RGB}{211,211,211}\n" <> 
           "\\definecolor{darkgray}{RGB}{169,169,169}\n" <> 
           "\\definecolor{orange}{RGB}{255,165,0}\n" <> 
           "\\definecolor{purple}{RGB}{128,0,128}\n" <> 
           "\\definecolor{pink}{RGB}{255,192,203}\n" <> 
           "\n\\begin{document}\n" <> VilTeX`Private`tikzCode <> 
           "\n\\end{document}"; 
         VilTeX`Private`folderName = FileBaseName[VilTeX`Private`filename]; 
         VilTeX`Private`folderPath = 
          FileNameJoin[{$HomeDirectory, "Downloads", 
             VilTeX`Private`folderName}]; If[
           Not[
            DirectoryQ[VilTeX`Private`folderPath]], 
           CreateDirectory[VilTeX`Private`folderPath]]; 
         VilTeX`Private`downloadPath = 
          FileNameJoin[{VilTeX`Private`folderPath, VilTeX`Private`filename}]; 
         Export[VilTeX`Private`downloadPath, VilTeX`Private`fullDocument, 
           "Text"]; VilTeX`Private`downloadPath]}], "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {Protected}, "FullName" -> 
    "VilTeX`ExportMaquinaToTikZ"|>, False]]], "Output",
 CellChangeTimes->{3.967111025861505*^9, 3.9671145326269903`*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"63f8a97a-1bb9-40a3-a89a-2fb06b38759c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 1", "Subsection",
 CellChangeTimes->{{3.967110703299527*^9, 
  3.9671107056555157`*^9}},ExpressionUUID->"4097ae79-971c-4c28-bf03-\
96b89163b705"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"maqu1", "=", 
   RowBox[{
    RowBox[{"MaquinaRandom", "[", 
     RowBox[{"4", ",", "3", ",", "2", ",", 
      RowBox[{"componentes", "->", "True"}]}], "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"MaquinaToDiagrama", "[", 
  RowBox[{
   RowBox[{"maqu1", "[", 
    RowBox[{"[", "1", "]"}], "]"}], ",", 
   RowBox[{"maqu1", "[", 
    RowBox[{"[", "2", "]"}], "]"}], ",", 
   RowBox[{"maqu1", "[", 
    RowBox[{"[", "3", "]"}], "]"}], ",", 
   RowBox[{"maqu1", "[", 
    RowBox[{"[", "4", "]"}], "]"}], ",", 
   RowBox[{"maqu1", "[", 
    RowBox[{"[", "5", "]"}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportMaquinaToTikZ", "[", 
   RowBox[{
    RowBox[{"maqu1", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", 
    RowBox[{"maqu1", "[", 
     RowBox[{"[", "2", "]"}], "]"}], ",", 
    RowBox[{"maqu1", "[", 
     RowBox[{"[", "3", "]"}], "]"}], ",", 
    RowBox[{"maqu1", "[", 
     RowBox[{"[", "4", "]"}], "]"}], ",", 
    RowBox[{"maqu1", "[", 
     RowBox[{"[", "5", "]"}], "]"}], ",", "\"\<maqu1.tex\>\"", ",", 
    RowBox[{"\"\<StateSize\>\"", "->", "0.8"}], ",", 
    RowBox[{"\"\<NodeDistance\>\"", "->", "4"}], ",", 
    RowBox[{"\"\<StateColor\>\"", "->", "\"\<lightblue\>\""}], ",", 
    RowBox[{"\"\<ArrowThickness\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<LayoutStyle\>\"", "->", "\"\<grid\>\""}], ",", 
    RowBox[{"\"\<TransitionColor\>\"", "->", "\"\<purple\>\""}], ",", 
    RowBox[{"\"\<ShowGrid\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<ShowAxes\>\"", "->", "False"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQAGIQnRzUdmVl31vHM71LwXTIt9SXINqlnO8ViHbg/P8T
RPvKZ/8C0W+Uf7OvAtKis3fxgeiMWBsREP0nd58kiHa6aKsBoqfOuagJope8
+akLoq9cW+kLon/uXRQDopkO88SC6D1lfxLA+s2vpIHoT+fOFoBoq46NxWDz
H8yuAtFFDltrQHQA579GEH3qbW8biO6IPDEXRJ/IuQymuVqKToNoA9nSdyD6
UODVTyA6Vq3tG4i2uX2ceTWQniQqxwqi43rnS4DouwdWK4DonpyZqiC6SI1H
DURfmMWiB6KtvsaB6W+f5luA6DbzHmcQHSUttx5EP7Oy2gCiZYLkGNYA6QOs
V9lB9KEFEYIgevbEEjC9JZpJHETH7VQH0wAhZNI2
  "],
 CellLabel->"In[45]:=",ExpressionUUID->"7e4a6b0f-20c1-4546-84c2-f8838fb39b6e"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{"", 
       Subscript[$CellContext`\[Sigma], 3], 
       Subscript[$CellContext`\[Sigma], 0], 
       Subscript[$CellContext`\[Sigma], 2], 
       Subscript[$CellContext`\[Sigma], 1]}, {{{1, 2}, {3, 4}, {3, 2}, {5, 
       5}, {5, 2}, {4, 2}, {4, 5}, {4, 4}, {2, 2}, {2, 5}, {2, 4}}, Null}, {
      EdgeLabels -> {DirectedEdge[
           Subscript[$CellContext`\[Sigma], 0], 
           Subscript[$CellContext`\[Sigma], 2]] -> "a/0,c/0", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 1], 
           Subscript[$CellContext`\[Sigma], 3]] -> "b/1,c/0", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 1], 
           Subscript[$CellContext`\[Sigma], 1]] -> "a/0", DirectedEdge["", 
           Subscript[$CellContext`\[Sigma], 3]] -> "", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 0], 
           Subscript[$CellContext`\[Sigma], 3]] -> "b/1", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 3], 
           Subscript[$CellContext`\[Sigma], 3]] -> "a/0", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 2], 
           Subscript[$CellContext`\[Sigma], 1]] -> "b/1", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 2], 
           Subscript[$CellContext`\[Sigma], 2]] -> "c/0", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 3], 
           Subscript[$CellContext`\[Sigma], 2]] -> "c/0", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 3], 
           Subscript[$CellContext`\[Sigma], 1]] -> "b/1", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 2], 
           Subscript[$CellContext`\[Sigma], 3]] -> "a/1"}, 
       EdgeWeight -> {
        "", "a/0,c/0", "b/1", "a/0", "b/1,c/0", "a/1", "b/1", "c/0", "a/0", 
         "b/1", "c/0"}, ImagePadding -> 10, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.7], Opacity[0.7], CapForm["Round"], Arrowheads[
        Medium], {
         ArrowBox[{{2.1087638911029187`, 0.8345432244348943}, {
          0.9381201394161294, 0.8337925333853413}}, 0.023487894829931105`], 
         InsetBox["\<\"\"\>", {1.523442015259524, 0.8341678789101178}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{0.9381201394161294, 0.8337925333853413}, {
           0.8503480824323435, 1.138115055212766}, {0.9286748024552077, 
           1.2588545290793995`}, {1.0165541991195788`, 1.2998177131858348`}, {
           1.2602861117254567`, 1.1795387643346207`}, {1.2812331476952807`, 
           1.0848709636085525`}, {1.2330514747258596`, 0.9492552491466973}, {
           0.9381201394161294, 0.8337925333853413}},
           SplineDegree->7], 0.023487894829931105`], 
         InsetBox["\<\"a/0\"\>", {1.1593882889528562, 1.2821678293156509}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{0.9381201394161294, 0.8337925333853413}, {
           0.468998053571167, 0.6797159235302402}, {0., 0.834169667021373}}], 
          0.023487894829931105`], 
         InsetBox["\<\"c/0\"\>", {0.4690336703535424, 0.7683126904442281}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{0.9381201394161294, 0.8337925333853413}, {
           0.7572512463404206, 0.3123190683938122}, {0.30216341889352727`, 
           0.}}], 0.023487894829931105`], 
         InsetBox["\<\"b/1\"\>", {0.6785072564918021, 0.3723792962560884}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{0.30071174576141985`, 1.666535253973115}, {
          0.9381201394161294, 0.8337925333853413}}, 0.023487894829931105`], 
         InsetBox["\<\"b/1\"\>", {0.6194159425887746, 1.250163893679228}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{0.30071174576141985`, 1.666535253973115}, {0., 
          0.834169667021373}}, 0.023487894829931105`], 
         InsetBox["\<\"a/0,c/0\"\>", {0.15035587288070992, 1.250352460497244},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{0., 0.834169667021373}, {0.46912208584496495`, 
           0.9882462768764756}, {0.9381201394161294, 0.8337925333853413}}], 
          0.023487894829931105`], 
         InsetBox["\<\"a/1\"\>", {0.4690864690625869, 0.8996495099624864}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{0., 0.834169667021373}, {-0.09140771925561662, 
           0.6409819596333406}, {-0.28964153799833514`, 
           0.5872974367995406}, {-0.41553515652251555`, 
           0.6467562549246962}, {-0.4156939256768823, 
           1.0212306557262683`}, {-0.28985077094435224`, 
           1.0807962048710276`}, {-0.0915715012939707, 1.0272797951248105`}, {
           0., 0.834169667021373}},
           SplineDegree->7], 0.023487894829931105`], 
         InsetBox["\<\"c/0\"\>", {-0.4999999550605302, 0.833957677710813}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{0., 0.834169667021373}, {0.30216341889352727`, 0.}}, 
          0.023487894829931105`], 
         InsetBox["\<\"b/1\"\>", {0.15108170944676363, 0.4170848335106865}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{0.30216341889352727`, 0.}, {0.48303231196923907`, 
           0.5214734649915319}, {0.9381201394161294, 0.8337925333853413}}], 
          0.023487894829931105`], 
         InsetBox["\<\"b/1,c/0\"\>", {0.5617763018178544, 0.46141323712925275},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{0.30216341889352727`, 0.}, {
           0.4773462631239227, -0.11635250734252327`}, {
           0.5029721748357038, -0.3214780728880249}, {
           0.42543537879048593`, -0.43825285666418123`}, {
           0.05333221723139517, -0.3812408366774631}, {
           0.014314974542938287`, -0.24660815253309995`}, {
           0.10018050651827567`, -0.05856481867089102}, {0.30216341889352727`,
            0.}},
           SplineDegree->7], 0.023487894829931105`], 
         InsetBox["\<\"a/0\"\>", {0.2264392618487869, -0.49423258901033984}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}}, 
       {Hue[0.6, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.1087638911029187`, 0.8345432244348943}, 
          0.023487894829931105], 
         InsetBox["\<\"\"\>", 
          Offset[{2, 2}, {2.13225178593285, 0.8580311192648253}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9381201394161294, 0.8337925333853413}, 
          0.023487894829931105], InsetBox[
          SubscriptBox["\[Sigma]", "3"], 
          Offset[{2, 2}, {0.9616080342460605, 0.8572804282152724}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.30071174576141985`, 1.666535253973115}, 
          0.023487894829931105], InsetBox[
          SubscriptBox["\[Sigma]", "0"], 
          Offset[{2, 2}, {0.324199640591351, 1.6900231488030462}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.834169667021373}, 0.023487894829931105], InsetBox[
          SubscriptBox["\[Sigma]", "2"], 
          Offset[{2, 2}, {0.023487894829931105, 0.857657561851304}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.30216341889352727`, 0.}, 0.023487894829931105], InsetBox[
          SubscriptBox["\[Sigma]", "1"], 
          Offset[{2, 2}, {0.32565131372345835, 0.023487894829931105}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->"NetworkGraphics",
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{
  3.9671112897853403`*^9, {3.967111356012937*^9, 3.967111374728649*^9}, {
   3.967111462929455*^9, 3.967111503481102*^9}, {3.967111536911441*^9, 
   3.967111789776894*^9}, 3.967111913490499*^9, {3.9671119442506104`*^9, 
   3.967111991739828*^9}, {3.967112071402907*^9, 3.9671120946215878`*^9}, {
   3.967112149822093*^9, 3.967112166587244*^9}, {3.967112209242474*^9, 
   3.9671122447494593`*^9}, 3.967112432702684*^9, {3.967112795931026*^9, 
   3.9671128292559*^9}, {3.967112859670529*^9, 3.967112964878121*^9}, {
   3.967113014644959*^9, 3.967113045108206*^9}, 3.967113076555399*^9, {
   3.967113132958617*^9, 3.9671131609009933`*^9}, 3.967113257587974*^9, {
   3.967113395985811*^9, 3.9671134414483*^9}, 3.967113478147794*^9, 
   3.967113520866158*^9, 3.967113588088956*^9, {3.9671136549600973`*^9, 
   3.9671137573166018`*^9}, {3.9671153783764677`*^9, 3.967115404747993*^9}, 
   3.967115455642705*^9, 3.9671161145419397`*^9},
 CellLabel->"Out[46]=",ExpressionUUID->"e7fcdd3d-f2c3-4760-9022-82c7f545d7c6"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967111289789322*^9, {3.9671113560137663`*^9, 3.967111374754168*^9}, {
   3.967111462938332*^9, 3.967111503485402*^9}, {3.967111536918332*^9, 
   3.96711178978083*^9}, 3.967111913494673*^9, {3.967111944258339*^9, 
   3.9671119917437143`*^9}, {3.967112071406743*^9, 3.967112094625931*^9}, {
   3.967112149826233*^9, 3.9671121665912046`*^9}, {3.967112209244664*^9, 
   3.967112244776362*^9}, 3.967112432707341*^9, {3.967112795935425*^9, 
   3.9671128292829037`*^9}, {3.967112859672742*^9, 3.967112964882215*^9}, {
   3.967113014649088*^9, 3.9671130451134043`*^9}, 3.96711307655978*^9, {
   3.967113132962597*^9, 3.9671131609053783`*^9}, 3.9671132575918503`*^9, {
   3.96711339598967*^9, 3.967113441450101*^9}, 3.967113478151873*^9, 
   3.967113520868168*^9, 3.967113588115982*^9, {3.9671136549623528`*^9, 
   3.967113757318589*^9}, {3.967115378425706*^9, 3.967115404749692*^9}, 
   3.967115455653802*^9, 3.967116114546023*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[45]:=",ExpressionUUID->"975537a7-0595-4f27-ab8b-abadfaec27bd"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967111289789322*^9, {3.9671113560137663`*^9, 3.967111374754168*^9}, {
   3.967111462938332*^9, 3.967111503485402*^9}, {3.967111536918332*^9, 
   3.96711178978083*^9}, 3.967111913494673*^9, {3.967111944258339*^9, 
   3.9671119917437143`*^9}, {3.967112071406743*^9, 3.967112094625931*^9}, {
   3.967112149826233*^9, 3.9671121665912046`*^9}, {3.967112209244664*^9, 
   3.967112244776362*^9}, 3.967112432707341*^9, {3.967112795935425*^9, 
   3.9671128292829037`*^9}, {3.967112859672742*^9, 3.967112964882215*^9}, {
   3.967113014649088*^9, 3.9671130451134043`*^9}, 3.96711307655978*^9, {
   3.967113132962597*^9, 3.9671131609053783`*^9}, 3.9671132575918503`*^9, {
   3.96711339598967*^9, 3.967113441450101*^9}, 3.967113478151873*^9, 
   3.967113520868168*^9, 3.967113588115982*^9, {3.9671136549623528`*^9, 
   3.967113757318589*^9}, {3.967115378425706*^9, 3.967115404749692*^9}, 
   3.967115455653802*^9, 3.96711611454701*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[45]:=",ExpressionUUID->"a27f352b-2803-47f3-a2a6-4e43d94c39a1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967111289789322*^9, {3.9671113560137663`*^9, 3.967111374754168*^9}, {
   3.967111462938332*^9, 3.967111503485402*^9}, {3.967111536918332*^9, 
   3.96711178978083*^9}, 3.967111913494673*^9, {3.967111944258339*^9, 
   3.9671119917437143`*^9}, {3.967112071406743*^9, 3.967112094625931*^9}, {
   3.967112149826233*^9, 3.9671121665912046`*^9}, {3.967112209244664*^9, 
   3.967112244776362*^9}, 3.967112432707341*^9, {3.967112795935425*^9, 
   3.9671128292829037`*^9}, {3.967112859672742*^9, 3.967112964882215*^9}, {
   3.967113014649088*^9, 3.9671130451134043`*^9}, 3.96711307655978*^9, {
   3.967113132962597*^9, 3.9671131609053783`*^9}, 3.9671132575918503`*^9, {
   3.96711339598967*^9, 3.967113441450101*^9}, 3.967113478151873*^9, 
   3.967113520868168*^9, 3.967113588115982*^9, {3.9671136549623528`*^9, 
   3.967113757318589*^9}, {3.967115378425706*^9, 3.967115404749692*^9}, 
   3.967115455653802*^9, 3.9671161145475082`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[45]:=",ExpressionUUID->"e65e6143-0d41-4d59-9bf0-7753f844f421"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967111289789322*^9, {3.9671113560137663`*^9, 3.967111374754168*^9}, {
   3.967111462938332*^9, 3.967111503485402*^9}, {3.967111536918332*^9, 
   3.96711178978083*^9}, 3.967111913494673*^9, {3.967111944258339*^9, 
   3.9671119917437143`*^9}, {3.967112071406743*^9, 3.967112094625931*^9}, {
   3.967112149826233*^9, 3.9671121665912046`*^9}, {3.967112209244664*^9, 
   3.967112244776362*^9}, 3.967112432707341*^9, {3.967112795935425*^9, 
   3.9671128292829037`*^9}, {3.967112859672742*^9, 3.967112964882215*^9}, {
   3.967113014649088*^9, 3.9671130451134043`*^9}, 3.96711307655978*^9, {
   3.967113132962597*^9, 3.9671131609053783`*^9}, 3.9671132575918503`*^9, {
   3.96711339598967*^9, 3.967113441450101*^9}, 3.967113478151873*^9, 
   3.967113520868168*^9, 3.967113588115982*^9, {3.9671136549623528`*^9, 
   3.967113757318589*^9}, {3.967115378425706*^9, 3.967115404749692*^9}, 
   3.967115455653802*^9, 3.967116114547843*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[45]:=",ExpressionUUID->"e1a131cf-40ce-4d86-8eeb-31d4868d8aad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967111289789322*^9, {3.9671113560137663`*^9, 3.967111374754168*^9}, {
   3.967111462938332*^9, 3.967111503485402*^9}, {3.967111536918332*^9, 
   3.96711178978083*^9}, 3.967111913494673*^9, {3.967111944258339*^9, 
   3.9671119917437143`*^9}, {3.967112071406743*^9, 3.967112094625931*^9}, {
   3.967112149826233*^9, 3.9671121665912046`*^9}, {3.967112209244664*^9, 
   3.967112244776362*^9}, 3.967112432707341*^9, {3.967112795935425*^9, 
   3.9671128292829037`*^9}, {3.967112859672742*^9, 3.967112964882215*^9}, {
   3.967113014649088*^9, 3.9671130451134043`*^9}, 3.96711307655978*^9, {
   3.967113132962597*^9, 3.9671131609053783`*^9}, 3.9671132575918503`*^9, {
   3.96711339598967*^9, 3.967113441450101*^9}, 3.967113478151873*^9, 
   3.967113520868168*^9, 3.967113588115982*^9, {3.9671136549623528`*^9, 
   3.967113757318589*^9}, {3.967115378425706*^9, 3.967115404749692*^9}, 
   3.967115455653802*^9, 3.967116114548173*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[45]:=",ExpressionUUID->"ea7ab197-9577-488b-8f41-a11701ff3694"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967111289789322*^9, {3.9671113560137663`*^9, 3.967111374754168*^9}, {
   3.967111462938332*^9, 3.967111503485402*^9}, {3.967111536918332*^9, 
   3.96711178978083*^9}, 3.967111913494673*^9, {3.967111944258339*^9, 
   3.9671119917437143`*^9}, {3.967112071406743*^9, 3.967112094625931*^9}, {
   3.967112149826233*^9, 3.9671121665912046`*^9}, {3.967112209244664*^9, 
   3.967112244776362*^9}, 3.967112432707341*^9, {3.967112795935425*^9, 
   3.9671128292829037`*^9}, {3.967112859672742*^9, 3.967112964882215*^9}, {
   3.967113014649088*^9, 3.9671130451134043`*^9}, 3.96711307655978*^9, {
   3.967113132962597*^9, 3.9671131609053783`*^9}, 3.9671132575918503`*^9, {
   3.96711339598967*^9, 3.967113441450101*^9}, 3.967113478151873*^9, 
   3.967113520868168*^9, 3.967113588115982*^9, {3.9671136549623528`*^9, 
   3.967113757318589*^9}, {3.967115378425706*^9, 3.967115404749692*^9}, 
   3.967115455653802*^9, 3.9671161146293*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[45]:=",ExpressionUUID->"aa01e4b7-6038-40e8-8ad7-a940e53bb35d"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967111289789322*^9, {3.9671113560137663`*^9, 3.967111374754168*^9}, {
   3.967111462938332*^9, 3.967111503485402*^9}, {3.967111536918332*^9, 
   3.96711178978083*^9}, 3.967111913494673*^9, {3.967111944258339*^9, 
   3.9671119917437143`*^9}, {3.967112071406743*^9, 3.967112094625931*^9}, {
   3.967112149826233*^9, 3.9671121665912046`*^9}, {3.967112209244664*^9, 
   3.967112244776362*^9}, 3.967112432707341*^9, {3.967112795935425*^9, 
   3.9671128292829037`*^9}, {3.967112859672742*^9, 3.967112964882215*^9}, {
   3.967113014649088*^9, 3.9671130451134043`*^9}, 3.96711307655978*^9, {
   3.967113132962597*^9, 3.9671131609053783`*^9}, 3.9671132575918503`*^9, {
   3.96711339598967*^9, 3.967113441450101*^9}, 3.967113478151873*^9, 
   3.967113520868168*^9, 3.967113588115982*^9, {3.9671136549623528`*^9, 
   3.967113757318589*^9}, {3.967115378425706*^9, 3.967115404749692*^9}, 
   3.967115455653802*^9, 3.9671161156343107`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[45]:=",ExpressionUUID->"0679660b-003b-467f-9ad8-7b9d718bd3e9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/maqu1/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", "/Users/enriquevilchezquesada/Downloads/maqu1/"],
  
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967111289789322*^9, {3.9671113560137663`*^9, 3.967111374754168*^9}, {
   3.967111462938332*^9, 3.967111503485402*^9}, {3.967111536918332*^9, 
   3.96711178978083*^9}, 3.967111913494673*^9, {3.967111944258339*^9, 
   3.9671119917437143`*^9}, {3.967112071406743*^9, 3.967112094625931*^9}, {
   3.967112149826233*^9, 3.9671121665912046`*^9}, {3.967112209244664*^9, 
   3.967112244776362*^9}, 3.967112432707341*^9, {3.967112795935425*^9, 
   3.9671128292829037`*^9}, {3.967112859672742*^9, 3.967112964882215*^9}, {
   3.967113014649088*^9, 3.9671130451134043`*^9}, 3.96711307655978*^9, {
   3.967113132962597*^9, 3.9671131609053783`*^9}, 3.9671132575918503`*^9, {
   3.96711339598967*^9, 3.967113441450101*^9}, 3.967113478151873*^9, 
   3.967113520868168*^9, 3.967113588115982*^9, {3.9671136549623528`*^9, 
   3.967113757318589*^9}, {3.967115378425706*^9, 3.967115404749692*^9}, 
   3.967115455653802*^9, 3.967116115637218*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[45]:=",ExpressionUUID->"475d3537-dd55-47ad-929d-71637e86320e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"maqu1\"\>"}],
  SequenceForm["Archivo: ", "maqu1"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967111289789322*^9, {3.9671113560137663`*^9, 3.967111374754168*^9}, {
   3.967111462938332*^9, 3.967111503485402*^9}, {3.967111536918332*^9, 
   3.96711178978083*^9}, 3.967111913494673*^9, {3.967111944258339*^9, 
   3.9671119917437143`*^9}, {3.967112071406743*^9, 3.967112094625931*^9}, {
   3.967112149826233*^9, 3.9671121665912046`*^9}, {3.967112209244664*^9, 
   3.967112244776362*^9}, 3.967112432707341*^9, {3.967112795935425*^9, 
   3.9671128292829037`*^9}, {3.967112859672742*^9, 3.967112964882215*^9}, {
   3.967113014649088*^9, 3.9671130451134043`*^9}, 3.96711307655978*^9, {
   3.967113132962597*^9, 3.9671131609053783`*^9}, 3.9671132575918503`*^9, {
   3.96711339598967*^9, 3.967113441450101*^9}, 3.967113478151873*^9, 
   3.967113520868168*^9, 3.967113588115982*^9, {3.9671136549623528`*^9, 
   3.967113757318589*^9}, {3.967115378425706*^9, 3.967115404749692*^9}, 
   3.967115455653802*^9, 3.9671161156396847`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[45]:=",ExpressionUUID->"90c2404a-00da-41bf-97ac-7339d349ed5f"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.967111289789322*^9, {3.9671113560137663`*^9, 3.967111374754168*^9}, {
   3.967111462938332*^9, 3.967111503485402*^9}, {3.967111536918332*^9, 
   3.96711178978083*^9}, 3.967111913494673*^9, {3.967111944258339*^9, 
   3.9671119917437143`*^9}, {3.967112071406743*^9, 3.967112094625931*^9}, {
   3.967112149826233*^9, 3.9671121665912046`*^9}, {3.967112209244664*^9, 
   3.967112244776362*^9}, 3.967112432707341*^9, {3.967112795935425*^9, 
   3.9671128292829037`*^9}, {3.967112859672742*^9, 3.967112964882215*^9}, {
   3.967113014649088*^9, 3.9671130451134043`*^9}, 3.96711307655978*^9, {
   3.967113132962597*^9, 3.9671131609053783`*^9}, 3.9671132575918503`*^9, {
   3.96711339598967*^9, 3.967113441450101*^9}, 3.967113478151873*^9, 
   3.967113520868168*^9, 3.967113588115982*^9, {3.9671136549623528`*^9, 
   3.967113757318589*^9}, {3.967115378425706*^9, 3.967115404749692*^9}, 
   3.967115455653802*^9, 3.9671161161618567`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[45]:=",ExpressionUUID->"e0fd7337-bc47-4609-9665-58571ddf2716"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/maqu1/maqu1.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", "/Users/enriquevilchezquesada/Downloads/maqu1/maqu1.pdf"],
  
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967111289789322*^9, {3.9671113560137663`*^9, 3.967111374754168*^9}, {
   3.967111462938332*^9, 3.967111503485402*^9}, {3.967111536918332*^9, 
   3.96711178978083*^9}, 3.967111913494673*^9, {3.967111944258339*^9, 
   3.9671119917437143`*^9}, {3.967112071406743*^9, 3.967112094625931*^9}, {
   3.967112149826233*^9, 3.9671121665912046`*^9}, {3.967112209244664*^9, 
   3.967112244776362*^9}, 3.967112432707341*^9, {3.967112795935425*^9, 
   3.9671128292829037`*^9}, {3.967112859672742*^9, 3.967112964882215*^9}, {
   3.967113014649088*^9, 3.9671130451134043`*^9}, 3.96711307655978*^9, {
   3.967113132962597*^9, 3.9671131609053783`*^9}, 3.9671132575918503`*^9, {
   3.96711339598967*^9, 3.967113441450101*^9}, 3.967113478151873*^9, 
   3.967113520868168*^9, 3.967113588115982*^9, {3.9671136549623528`*^9, 
   3.967113757318589*^9}, {3.967115378425706*^9, 3.967115404749692*^9}, 
   3.967115455653802*^9, 3.9671161161623993`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[45]:=",ExpressionUUID->"ecda08bc-c6df-43a4-b78c-59bfc52a9000"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/maqu1/maqu1.pdf\"\>"]\
, "Output",
 CellChangeTimes->{
  3.9671112897853403`*^9, {3.967111356012937*^9, 3.967111374728649*^9}, {
   3.967111462929455*^9, 3.967111503481102*^9}, {3.967111536911441*^9, 
   3.967111789776894*^9}, 3.967111913490499*^9, {3.9671119442506104`*^9, 
   3.967111991739828*^9}, {3.967112071402907*^9, 3.9671120946215878`*^9}, {
   3.967112149822093*^9, 3.967112166587244*^9}, {3.967112209242474*^9, 
   3.9671122447494593`*^9}, 3.967112432702684*^9, {3.967112795931026*^9, 
   3.9671128292559*^9}, {3.967112859670529*^9, 3.967112964878121*^9}, {
   3.967113014644959*^9, 3.967113045108206*^9}, 3.967113076555399*^9, {
   3.967113132958617*^9, 3.9671131609009933`*^9}, 3.967113257587974*^9, {
   3.967113395985811*^9, 3.9671134414483*^9}, 3.967113478147794*^9, 
   3.967113520866158*^9, 3.967113588088956*^9, {3.9671136549600973`*^9, 
   3.9671137573166018`*^9}, {3.9671153783764677`*^9, 3.967115404747993*^9}, 
   3.967115455642705*^9, 3.967116116173793*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"5d05a7ce-8189-4698-b9b0-8562997fbce7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 2", "Subsection",
 CellChangeTimes->{{3.967110703299527*^9, 
  3.967110733060464*^9}},ExpressionUUID->"390ce748-d4b2-4ade-a3d4-\
38dca5cf99b1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"maqu2", "=", 
   RowBox[{
    RowBox[{"MaquinaRandom", "[", 
     RowBox[{"5", ",", "3", ",", "2", ",", 
      RowBox[{"componentes", "->", "True"}]}], "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"MaquinaToDiagrama", "[", 
  RowBox[{
   RowBox[{"maqu2", "[", 
    RowBox[{"[", "1", "]"}], "]"}], ",", 
   RowBox[{"maqu2", "[", 
    RowBox[{"[", "2", "]"}], "]"}], ",", 
   RowBox[{"maqu2", "[", 
    RowBox[{"[", "3", "]"}], "]"}], ",", 
   RowBox[{"maqu2", "[", 
    RowBox[{"[", "4", "]"}], "]"}], ",", 
   RowBox[{"maqu2", "[", 
    RowBox[{"[", "5", "]"}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportMaquinaToTikZ", "[", 
   RowBox[{
    RowBox[{"maqu2", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", 
    RowBox[{"maqu2", "[", 
     RowBox[{"[", "2", "]"}], "]"}], ",", 
    RowBox[{"maqu2", "[", 
     RowBox[{"[", "3", "]"}], "]"}], ",", 
    RowBox[{"maqu2", "[", 
     RowBox[{"[", "4", "]"}], "]"}], ",", 
    RowBox[{"maqu2", "[", 
     RowBox[{"[", "5", "]"}], "]"}], ",", "\"\<maqu2.tex\>\"", ",", 
    RowBox[{"\"\<StateSize\>\"", "->", "1"}], ",", 
    RowBox[{"\"\<NodeDistance\>\"", "->", "5"}], ",", 
    RowBox[{"\"\<StateColor\>\"", "->", "\"\<Turquoise\>\""}], ",", 
    RowBox[{"\"\<ArrowThickness\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<LayoutStyle\>\"", "->", "\"\<spring\>\""}], ",", 
    RowBox[{"\"\<TransitionColor\>\"", "->", "\"\<Salmon\>\""}], ",", 
    RowBox[{"\"\<ShowGrid\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<ShowAxes\>\"", "->", "True"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{
  3.967110777912524*^9, {3.967110824547209*^9, 3.967110825343237*^9}, {
   3.967110998631357*^9, 3.9671110023220863`*^9}, {3.967111132602478*^9, 
   3.967111135843556*^9}, {3.967111391957734*^9, 3.967111399807762*^9}, {
   3.967115481840448*^9, 3.9671154831595507`*^9}, {3.967115548606925*^9, 
   3.967115600231529*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"d55d9e0a-f9de-4b71-ba35-946b80402343"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{"", 
       Subscript[$CellContext`\[Sigma], 3], 
       Subscript[$CellContext`\[Sigma], 0], 
       Subscript[$CellContext`\[Sigma], 4], 
       Subscript[$CellContext`\[Sigma], 1], 
       Subscript[$CellContext`\[Sigma], 2]}, {{{1, 2}, {3, 4}, {3, 5}, {5, 
       2}, {5, 4}, {5, 6}, {6, 4}, {6, 3}, {2, 2}, {2, 6}, {2, 5}, {4, 4}}, 
       Null}, {EdgeLabels -> {DirectedEdge[
           Subscript[$CellContext`\[Sigma], 1], 
           Subscript[$CellContext`\[Sigma], 3]] -> "a/0", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 0], 
           Subscript[$CellContext`\[Sigma], 1]] -> "b/1", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 0], 
           Subscript[$CellContext`\[Sigma], 4]] -> "a/0,c/1", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 2], 
           Subscript[$CellContext`\[Sigma], 4]] -> "a/1,c/1", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 2], 
           Subscript[$CellContext`\[Sigma], 0]] -> "b/1", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 3], 
           Subscript[$CellContext`\[Sigma], 2]] -> "b/0", DirectedEdge["", 
           Subscript[$CellContext`\[Sigma], 3]] -> "", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 3], 
           Subscript[$CellContext`\[Sigma], 1]] -> "c/0", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 3], 
           Subscript[$CellContext`\[Sigma], 3]] -> "a/0", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 1], 
           Subscript[$CellContext`\[Sigma], 4]] -> "b/1", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 4], 
           Subscript[$CellContext`\[Sigma], 4]] -> "a/0,b/1,c/0", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 1], 
           Subscript[$CellContext`\[Sigma], 2]] -> "c/0"}, 
       EdgeWeight -> {
        "", "a/0,c/1", "b/1", "a/0", "b/1", "c/0", "a/1,c/1", "b/1", "a/0", 
         "b/0", "c/0", "a/0,b/1,c/0"}, ImagePadding -> 10, 
       VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.7], Opacity[0.7], CapForm["Round"], Arrowheads[
        Medium], {
         ArrowBox[{{0., 0.36155096870892384`}, {1.182775279251588, 
          0.3617808380897475}}, 0.031135067125550697`], 
         InsetBox["\<\"\"\>", {0.591387639625794, 0.3616659033993357}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{1.182775279251588, 0.3617808380897475}, {
           1.3765643482730678`, 0.1652982707661651}, {
           1.3585825083859098`, -0.0063230190541560816`}, {
           1.2815978591161354`, -0.09379040756643812}, {
           0.9629719480331466, -0.04931228730289351}, {0.9128832608068324, 
           0.05589371864873038}, {0.9425874434353388, 0.2258786450971963}, {
           1.182775279251588, 0.3617808380897475}},
           SplineDegree->7], 0.031135067125550697`], 
         InsetBox["\<\"a/0\"\>", {1.1136487695108528, -0.13341763288029101}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{1.182775279251588, 0.3617808380897475}, {
           1.7834195203695993`, 0.3859094672646392}, {2.2811329761492636`, 
           0.048808575735170556`}}], 0.031135067125550697`], 
         InsetBox["\<\"c/0\"\>", {1.7538621860652461, 0.28217974569529647}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{1.182775279251588, 0.3617808380897475}, {
          2.2793406234086273`, 0.6758108646267547}}, 0.031135067125550697`], 
         InsetBox["\<\"b/0\"\>", {1.7310579513301076, 0.5187958513582511}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{3.125163687369959, 0.723599410852799}, {
          3.1258202956501377`, 0.}}, 0.031135067125550697`], 
         InsetBox["\<\"a/0,c/1\"\>", {3.1254919915100485, 0.3617997054263995},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{3.125163687369959, 0.723599410852799}, {
          2.2811329761492636`, 0.048808575735170556`}}, 
          0.031135067125550697`], 
         InsetBox["\<\"b/1\"\>", {2.7031483317596114, 0.3862039932939848}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{3.1258202956501377`, 0.}, {3.3252638385900326`, 
           0.06670238419370883}, {3.502836010894095, -0.03913385069131711}, {
           3.547312779792576, -0.17206286142741206`}, {
           3.2736728590951922`, -0.43058235211615314`}, {
           3.14348373617529, -0.37862951638726905`}, {
           3.0479009500434686`, -0.19533435554907216`}, {3.1258202956501377`, 
           0.}},
           SplineDegree->7], 0.031135067125550697`], 
         InsetBox["\<\"a/0,b/1,c/0\"\>", {3.4691894749319987, -0.363452344495535},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{2.2811329761492636`, 0.048808575735170556`}, {
           1.6804887350312534`, 0.02467994656027784}, {1.182775279251588, 
           0.3617808380897475}}], 0.031135067125550697`], 
         InsetBox["\<\"a/0\"\>", {1.7100460693356054, 0.12840966812962162}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{2.2811329761492636`, 0.048808575735170556`}, {
          3.1258202956501377`, 0.}}, 0.031135067125550697`], 
         InsetBox["\<\"b/1\"\>", {2.7034766358997007, 0.024404287867585278}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{2.2811329761492636`, 0.048808575735170556`}, {
          2.2793406234086273`, 0.6758108646267547}}, 0.031135067125550697`], 
         InsetBox["\<\"c/0\"\>", {2.2802367997789457, 0.36230972018096264}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{2.2793406234086273`, 0.6758108646267547}, {
          3.125163687369959, 0.723599410852799}}, 0.031135067125550697`], 
         InsetBox["\<\"b/1\"\>", {2.702252155389293, 0.6997051377397768}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{2.2793406234086273`, 0.6758108646267547}, {
          3.1258202956501377`, 0.}}, 0.031135067125550697`], 
         InsetBox["\<\"a/1,c/1\"\>", {2.7025804595293828, 0.33790543231337733},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}}, 
       {Hue[0.6, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {DiskBox[{0., 0.36155096870892384`}, 0.031135067125550697], 
         InsetBox["\<\"\"\>", 
          Offset[{2, 2}, {0.031135067125550697, 0.39268603583447453}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.182775279251588, 0.3617808380897475}, 
          0.031135067125550697], InsetBox[
          SubscriptBox["\[Sigma]", "3"], 
          Offset[{2, 2}, {1.2139103463771388, 0.3929159052152982}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.125163687369959, 0.723599410852799}, 
          0.031135067125550697], InsetBox[
          SubscriptBox["\[Sigma]", "0"], 
          Offset[{2, 2}, {3.1562987544955097, 0.7547344779783497}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.1258202956501377`, 0.}, 0.031135067125550697], InsetBox[
          SubscriptBox["\[Sigma]", "4"], 
          Offset[{2, 2}, {3.1569553627756886, 0.031135067125550697}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.2811329761492636`, 0.048808575735170556`}, 
          0.031135067125550697], InsetBox[
          SubscriptBox["\[Sigma]", "1"], 
          Offset[{2, 2}, {2.3122680432748144, 0.07994364286072125}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.2793406234086273`, 0.6758108646267547}, 
          0.031135067125550697], InsetBox[
          SubscriptBox["\[Sigma]", "2"], 
          Offset[{2, 2}, {2.310475690534178, 0.7069459317523054}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->"NetworkGraphics",
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{{3.967115605076453*^9, 3.967115632006364*^9}, 
   3.967116126851666*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"0bb30d84-c786-4f95-8032-d68a20e2b3aa"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967115605080904*^9, 3.967115632010602*^9}, 
   3.967116126858102*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"bdffef4d-3922-44e3-855e-50be17df62f1"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.967115605080904*^9, 3.967115632010602*^9}, 
   3.967116126859243*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"042befec-6cb4-4da5-bb0f-2cec39342f14"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967115605080904*^9, 3.967115632010602*^9}, 
   3.967116126859749*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"9fffa307-5759-4d28-941b-2dcff3739f51"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967115605080904*^9, 3.967115632010602*^9}, 
   3.967116126860091*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"5a42f3e7-618c-40d8-8229-09c0dc178477"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967115605080904*^9, 3.967115632010602*^9}, 
   3.967116126860423*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"f7b3c77d-d9bd-4eed-8bf4-89771b444ff9"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.967115605080904*^9, 3.967115632010602*^9}, 
   3.96711612694728*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"679b5a42-cb08-43fd-99cf-2eb6990a5ab1"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.967115605080904*^9, 3.967115632010602*^9}, 
   3.967116127953182*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"192c72ae-c2d4-4915-9d5a-6bb25dd1b317"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/maqu2/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", "/Users/enriquevilchezquesada/Downloads/maqu2/"],
  
  Editable->False]], "Print",
 CellChangeTimes->{{3.967115605080904*^9, 3.967115632010602*^9}, 
   3.967116127955955*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"73bd51da-90b9-4c8b-a42f-a3d9fba3bd83"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"maqu2\"\>"}],
  SequenceForm["Archivo: ", "maqu2"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967115605080904*^9, 3.967115632010602*^9}, 
   3.967116127958271*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"093b8562-6a10-4c8f-b02b-d89e35abfbf0"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.967115605080904*^9, 3.967115632010602*^9}, 
   3.9671161284932213`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"712a2e15-aa77-46a7-9c1a-c3ae57014a8d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/maqu2/maqu2.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", "/Users/enriquevilchezquesada/Downloads/maqu2/maqu2.pdf"],
  
  Editable->False]], "Print",
 CellChangeTimes->{{3.967115605080904*^9, 3.967115632010602*^9}, 
   3.967116128493731*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"85491409-31be-4ee7-864d-8827f8088424"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/maqu2/maqu2.pdf\"\>"]\
, "Output",
 CellChangeTimes->{{3.967115605076453*^9, 3.967115632006364*^9}, 
   3.96711612850567*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"89c8e2d1-18aa-486d-85d7-b0f56b64b79b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 3", "Subsection",
 CellChangeTimes->{{3.967110703299527*^9, 3.9671107056555157`*^9}, 
   3.967110735731491*^9},ExpressionUUID->"a0dbba57-230a-4afc-9f8e-\
6a67ecf8d84e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"maqu3", "=", 
   RowBox[{
    RowBox[{"MaquinaRandom", "[", 
     RowBox[{"6", ",", "3", ",", "3", ",", 
      RowBox[{"componentes", "->", "True"}]}], "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"MaquinaToDiagrama", "[", 
  RowBox[{
   RowBox[{"maqu3", "[", 
    RowBox[{"[", "1", "]"}], "]"}], ",", 
   RowBox[{"maqu3", "[", 
    RowBox[{"[", "2", "]"}], "]"}], ",", 
   RowBox[{"maqu3", "[", 
    RowBox[{"[", "3", "]"}], "]"}], ",", 
   RowBox[{"maqu3", "[", 
    RowBox[{"[", "4", "]"}], "]"}], ",", 
   RowBox[{"maqu3", "[", 
    RowBox[{"[", "5", "]"}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportMaquinaToTikZ", "[", 
   RowBox[{
    RowBox[{"maqu3", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", 
    RowBox[{"maqu3", "[", 
     RowBox[{"[", "2", "]"}], "]"}], ",", 
    RowBox[{"maqu3", "[", 
     RowBox[{"[", "3", "]"}], "]"}], ",", 
    RowBox[{"maqu3", "[", 
     RowBox[{"[", "4", "]"}], "]"}], ",", 
    RowBox[{"maqu3", "[", 
     RowBox[{"[", "5", "]"}], "]"}], ",", "\"\<maqu3.tex\>\"", ",", 
    RowBox[{"\"\<StateSize\>\"", "->", "0.5"}], ",", 
    RowBox[{"\"\<NodeDistance\>\"", "->", "4.2"}], ",", 
    RowBox[{"\"\<StateColor\>\"", "->", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<red\>\"", ",", "\"\<blue\>\"", ",", "\"\<green\>\"", 
        ",", "\"\<orange\>\"", ",", "\"\<purple\>\"", ",", "\"\<brown\>\"", 
        ",", "\"\<pink\>\"", ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", 
        ",", "\"\<yellow\>\"", ",", "\"\<black\>\"", ",", "\"\<white\>\"", 
        ",", "\"\<gray\>\"", ",", "\"\<Red\>\"", ",", "\"\<Blue\>\"", 
        ",", "\"\<Green\>\"", ",", "\"\<Violet\>\"", ",", "\"\<Gray\>\"", 
        ",", "\"\<LightGray\>\"", ",", "\"\<Yellow\>\"", 
        ",", "\"\<Emerald\>\"", ",", "\"\<Turquoise\>\"", 
        ",", "\"\<Lavender\>\"", ",", "\"\<Peach\>\"", ",", "\"\<Salmon\>\"", 
        ",", "\"\<lightblue\>\"", ",", "\"\<lightgreen\>\"", 
        ",", "\"\<lightyellow\>\"", ",", "\"\<lightgray\>\"", 
        ",", "\"\<darkgray\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"\"\<ArrowThickness\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<TransitionColor\>\"", "->", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<red\>\"", ",", "\"\<blue\>\"", ",", "\"\<green\>\"", 
        ",", "\"\<orange\>\"", ",", "\"\<purple\>\"", ",", "\"\<brown\>\"", 
        ",", "\"\<pink\>\"", ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", 
        ",", "\"\<yellow\>\"", ",", "\"\<black\>\"", ",", "\"\<white\>\"", 
        ",", "\"\<gray\>\"", ",", "\"\<Red\>\"", ",", "\"\<Blue\>\"", 
        ",", "\"\<Green\>\"", ",", "\"\<Violet\>\"", ",", "\"\<Gray\>\"", 
        ",", "\"\<LightGray\>\"", ",", "\"\<Yellow\>\"", 
        ",", "\"\<Emerald\>\"", ",", "\"\<Turquoise\>\"", 
        ",", "\"\<Lavender\>\"", ",", "\"\<Peach\>\"", ",", "\"\<Salmon\>\"", 
        ",", "\"\<lightblue\>\"", ",", "\"\<lightgreen\>\"", 
        ",", "\"\<lightyellow\>\"", ",", "\"\<lightgray\>\"", 
        ",", "\"\<darkgray\>\""}], "}"}], "]"}]}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{
  3.9671107752268257`*^9, {3.967110828297097*^9, 3.967110829212853*^9}, {
   3.967111138957924*^9, 3.967111141633007*^9}, {3.967111404323135*^9, 
   3.967111414883507*^9}, {3.967115490423208*^9, 3.967115490786852*^9}, {
   3.967115645217065*^9, 3.967115659930469*^9}, {3.967115716793517*^9, 
   3.96711572407019*^9}, {3.967115767625909*^9, 3.967115770328648*^9}, {
   3.9671158026844*^9, 3.967115803105258*^9}, {3.967116023086492*^9, 
   3.967116026687058*^9}},
 CellLabel->"In[73]:=",ExpressionUUID->"44c00615-09be-496f-b244-b16c60c7b6eb"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{"", 
       Subscript[$CellContext`\[Sigma], 2], 
       Subscript[$CellContext`\[Sigma], 0], 
       Subscript[$CellContext`\[Sigma], 5], 
       Subscript[$CellContext`\[Sigma], 3], 
       Subscript[$CellContext`\[Sigma], 1], 
       Subscript[$CellContext`\[Sigma], 4]}, {{{1, 2}, {3, 4}, {3, 5}, {6, 
       3}, {6, 7}, {2, 5}, {2, 6}, {2, 3}, {5, 7}, {5, 2}, {7, 6}, {7, 2}, {7,
        7}, {4, 5}, {4, 2}, {4, 7}}, Null}, {EdgeLabels -> {DirectedEdge["", 
           Subscript[$CellContext`\[Sigma], 2]] -> "", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 3], 
           Subscript[$CellContext`\[Sigma], 4]] -> "a/2", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 1], 
           Subscript[$CellContext`\[Sigma], 0]] -> "a/0,c/1", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 2], 
           Subscript[$CellContext`\[Sigma], 0]] -> "c/1", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 3], 
           Subscript[$CellContext`\[Sigma], 2]] -> "b/2,c/2", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 2], 
           Subscript[$CellContext`\[Sigma], 3]] -> "a/0", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 5], 
           Subscript[$CellContext`\[Sigma], 3]] -> "a/0", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 0], 
           Subscript[$CellContext`\[Sigma], 3]] -> "b/2,c/1", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 5], 
           Subscript[$CellContext`\[Sigma], 4]] -> "c/2", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 1], 
           Subscript[$CellContext`\[Sigma], 4]] -> "b/2", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 4], 
           Subscript[$CellContext`\[Sigma], 4]] -> "c/1", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 2], 
           Subscript[$CellContext`\[Sigma], 1]] -> "b/1", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 4], 
           Subscript[$CellContext`\[Sigma], 1]] -> "a/2", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 0], 
           Subscript[$CellContext`\[Sigma], 5]] -> "a/0", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 4], 
           Subscript[$CellContext`\[Sigma], 2]] -> "b/2", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 5], 
           Subscript[$CellContext`\[Sigma], 2]] -> "b/2"}, 
       EdgeWeight -> {
        "", "a/0", "b/2,c/1", "a/0,c/1", "b/2", "a/0", "b/1", "c/1", "a/2", 
         "b/2,c/2", "a/2", "b/2", "c/1", "a/0", "b/2", "c/2"}, ImagePadding -> 
       10, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.7], Opacity[0.7], CapForm["Round"], Arrowheads[
        Medium], {
         ArrowBox[{{0., 1.11025232713256}, {1.3494706673827357`, 
          1.0099205977582535`}}, 0.02650462599199123], 
         InsetBox["\<\"\"\>", {0.6747353336913678, 1.0600864624454067}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{1.3494706673827357`, 1.0099205977582535`}, {
          1.9051872985626048`, 0.8469897900019028}}, 0.02650462599199123], 
         InsetBox["\<\"c/1\"\>", {1.6273289829726703, 0.9284551938800781}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{1.3494706673827357`, 1.0099205977582535`}, {
           1.8421711943797585`, 1.4416325962175596`}, {2.4949386045043176`, 
           1.496621387767713}}], 0.02650462599199123], 
         InsetBox["\<\"a/0\"\>", {1.8881355806428646, 1.3334537483614939}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{1.3494706673827357`, 1.0099205977582535`}, {
          1.8287293282753607`, 0.}}, 0.02650462599199123], 
         InsetBox["\<\"b/1\"\>", {1.5890999978290483, 0.5049602988791267}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{1.9051872985626048`, 0.8469897900019028}, {
          1.912569847894141, 1.7072732869691596`}}, 0.02650462599199123], 
         InsetBox["\<\"a/0\"\>", {1.9088785732283728, 1.277131538485531}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{1.9051872985626048`, 0.8469897900019028}, {
          2.4949386045043176`, 1.496621387767713}}, 0.02650462599199123], 
         InsetBox["\<\"b/2,c/1\"\>", {2.2000629515334613, 1.171805588884808}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{1.912569847894141, 1.7072732869691596`}, {
          1.3494706673827357`, 1.0099205977582535`}}, 0.02650462599199123], 
         InsetBox["\<\"b/2\"\>", {1.6310202576384385, 1.3585969423637065}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{1.912569847894141, 1.7072732869691596`}, {
          2.4949386045043176`, 1.496621387767713}}, 0.02650462599199123], 
         InsetBox["\<\"a/0\"\>", {2.203754226199229, 1.6019473373684363}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{1.912569847894141, 1.7072732869691596`}, {
          2.471292621744789, 0.7474093073134752}}, 0.02650462599199123], 
         InsetBox["\<\"c/2\"\>", {2.191931234819465, 1.2273412971413173}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{2.4949386045043176`, 1.496621387767713}, {
           2.002238077507296, 1.0649093893084047`}, {1.3494706673827357`, 
           1.0099205977582535`}}], 0.02650462599199123], 
         InsetBox["\<\"b/2,c/2\"\>", {1.956273691244189, 1.1730882371644724}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{2.4949386045043176`, 1.496621387767713}, {
          2.471292621744789, 0.7474093073134752}}, 0.02650462599199123], 
         InsetBox["\<\"a/2\"\>", {2.4831156131245535, 1.122015347540594}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{1.8287293282753607`, 0.}, {1.9051872985626048`, 
          0.8469897900019028}}, 0.02650462599199123], 
         InsetBox["\<\"a/0,c/1\"\>", {1.8669583134189827, 0.4234948950009514},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{1.8287293282753607`, 0.}, {2.027106430063839, 
           0.4793682417473054}, {2.471292621744789, 0.7474093073134752}}], 
          0.02650462599199123], 
         InsetBox["\<\"b/2\"\>", {2.0976923234981317, 0.4186840841995976}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{2.471292621744789, 0.7474093073134752}, {
          1.3494706673827357`, 1.0099205977582535`}}, 0.02650462599199123], 
         InsetBox["\<\"b/2\"\>", {1.9103816445637625, 0.8786649525358643}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{2.471292621744789, 0.7474093073134752}, {
           2.272915519956327, 0.2680410655661868}, {1.8287293282753607`, 
           0.}}], 0.02650462599199123], 
         InsetBox["\<\"a/2\"\>", {2.202329626522018, 0.32872522311387753}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{2.471292621744789, 0.7474093073134752}, {
           2.627679272027483, 0.8945855207123169}, {2.8313894838450056`, 
           0.8719867884064688}, {2.926705886306471, 0.7709000679344186}, {
           2.791222108103795, 0.4224505697307762}, {2.652655339031094, 
           0.412302065272326}, {2.4871843781669223`, 0.5332479796773156}, {
           2.471292621744789, 0.7474093073134752}},
           SplineDegree->7], 0.02650462599199123], 
         InsetBox["\<\"c/1\"\>", {2.937305961839521, 0.5662144761130474}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}}, 
       {Hue[0.6, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {DiskBox[{0., 1.11025232713256}, 0.02650462599199123], 
         InsetBox["\<\"\"\>", 
          Offset[{2, 2}, {0.02650462599199123, 1.1367569531245512}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.3494706673827357`, 1.0099205977582535`}, 
          0.02650462599199123], InsetBox[
          SubscriptBox["\[Sigma]", "2"], 
          Offset[{2, 2}, {1.375975293374727, 1.0364252237502447}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.9051872985626048`, 0.8469897900019028}, 
          0.02650462599199123], InsetBox[
          SubscriptBox["\[Sigma]", "0"], Offset[{2, 2}, 
          {1.931691924554596, 0.873494415993894}], ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.912569847894141, 1.7072732869691596`}, 
          0.02650462599199123], InsetBox[
          SubscriptBox["\[Sigma]", "5"], 
          Offset[{2, 2}, {1.9390744738861323, 1.7337779129611508}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.4949386045043176`, 1.496621387767713}, 
          0.02650462599199123], InsetBox[
          SubscriptBox["\[Sigma]", "3"], 
          Offset[{2, 2}, {2.521443230496309, 1.5231260137597042}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8287293282753607`, 0.}, 0.02650462599199123], InsetBox[
          SubscriptBox["\[Sigma]", "1"], 
          Offset[{2, 2}, {1.855233954267352, 0.02650462599199123}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.471292621744789, 0.7474093073134752}, 
          0.02650462599199123], InsetBox[
          SubscriptBox["\[Sigma]", "4"], 
          Offset[{2, 2}, {2.4977972477367802, 0.7739139333054664}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->"NetworkGraphics",
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{{3.967115787570012*^9, 3.967115803826333*^9}, {
  3.9671161457033443`*^9, 3.967116186949424*^9}},
 CellLabel->"Out[74]=",ExpressionUUID->"d92f4756-d395-4c45-bced-718f7cdabf33"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967115787574707*^9, 3.967115803835904*^9}, {
  3.967116145708097*^9, 3.9671161869542*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[73]:=",ExpressionUUID->"576691be-7827-49ed-8de5-ae1bcf75d19e"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.967115787574707*^9, 3.967115803835904*^9}, {
  3.967116145708097*^9, 3.967116186955213*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[73]:=",ExpressionUUID->"83fdbbe7-f01a-4e72-8d40-9ae5dd43bd95"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967115787574707*^9, 3.967115803835904*^9}, {
  3.967116145708097*^9, 3.967116186955654*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[73]:=",ExpressionUUID->"1295bcff-fa8f-4ffa-a3db-c8eed4655e94"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967115787574707*^9, 3.967115803835904*^9}, {
  3.967116145708097*^9, 3.967116186955963*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[73]:=",ExpressionUUID->"8174fedb-15e6-4cae-9e68-7176d02fd4aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967115787574707*^9, 3.967115803835904*^9}, {
  3.967116145708097*^9, 3.967116186956275*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[73]:=",ExpressionUUID->"a15cfaa4-6bb5-4287-af5f-081ecaceea76"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.967115787574707*^9, 3.967115803835904*^9}, {
  3.967116145708097*^9, 3.967116187052122*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[73]:=",ExpressionUUID->"5529631c-b6d7-4a72-b037-101671f61b53"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.967115787574707*^9, 3.967115803835904*^9}, {
  3.967116145708097*^9, 3.967116188058374*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[73]:=",ExpressionUUID->"446bcb30-c96e-49dd-98e5-fc8cf04aa7f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/maqu3/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", "/Users/enriquevilchezquesada/Downloads/maqu3/"],
  
  Editable->False]], "Print",
 CellChangeTimes->{{3.967115787574707*^9, 3.967115803835904*^9}, {
  3.967116145708097*^9, 3.9671161880616007`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[73]:=",ExpressionUUID->"f52a6e6f-ba73-4f65-b00b-ef5ffe16952a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"maqu3\"\>"}],
  SequenceForm["Archivo: ", "maqu3"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967115787574707*^9, 3.967115803835904*^9}, {
  3.967116145708097*^9, 3.967116188063736*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[73]:=",ExpressionUUID->"29ea552a-1324-4793-a5a9-9cb8e4f63ccc"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.967115787574707*^9, 3.967115803835904*^9}, {
  3.967116145708097*^9, 3.967116188606432*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[73]:=",ExpressionUUID->"f15640ab-9ddb-4237-a214-c3412927fc77"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/maqu3/maqu3.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", "/Users/enriquevilchezquesada/Downloads/maqu3/maqu3.pdf"],
  
  Editable->False]], "Print",
 CellChangeTimes->{{3.967115787574707*^9, 3.967115803835904*^9}, {
  3.967116145708097*^9, 3.967116188606958*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[73]:=",ExpressionUUID->"0d5414ac-8502-44be-ac87-52be97323ffe"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/maqu3/maqu3.pdf\"\>"]\
, "Output",
 CellChangeTimes->{{3.967115787570012*^9, 3.967115803826333*^9}, {
  3.9671161457033443`*^9, 3.967116188619192*^9}},
 CellLabel->"Out[76]=",ExpressionUUID->"2f8f9acc-44a2-46cb-b358-ce0c0fc5487e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 4", "Subsection",
 CellChangeTimes->{{3.967110703299527*^9, 3.9671107056555157`*^9}, 
   3.9671107385342417`*^9},ExpressionUUID->"a60a9292-b7c2-4e4d-9c1e-\
1e771e6ef1da"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"maqu4", "=", 
   RowBox[{
    RowBox[{"MaquinaRandom", "[", 
     RowBox[{"7", ",", "4", ",", "7", ",", 
      RowBox[{"componentes", "->", "True"}]}], "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"MaquinaToDiagrama", "[", 
  RowBox[{
   RowBox[{"maqu4", "[", 
    RowBox[{"[", "1", "]"}], "]"}], ",", 
   RowBox[{"maqu4", "[", 
    RowBox[{"[", "2", "]"}], "]"}], ",", 
   RowBox[{"maqu4", "[", 
    RowBox[{"[", "3", "]"}], "]"}], ",", 
   RowBox[{"maqu4", "[", 
    RowBox[{"[", "4", "]"}], "]"}], ",", 
   RowBox[{"maqu4", "[", 
    RowBox[{"[", "5", "]"}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportMaquinaToTikZ", "[", 
   RowBox[{
    RowBox[{"maqu4", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", 
    RowBox[{"maqu4", "[", 
     RowBox[{"[", "2", "]"}], "]"}], ",", 
    RowBox[{"maqu4", "[", 
     RowBox[{"[", "3", "]"}], "]"}], ",", 
    RowBox[{"maqu4", "[", 
     RowBox[{"[", "4", "]"}], "]"}], ",", 
    RowBox[{"maqu4", "[", 
     RowBox[{"[", "5", "]"}], "]"}], ",", "\"\<maqu4.tex\>\"", ",", 
    RowBox[{"\"\<StateSize\>\"", "->", "1.3"}], ",", 
    RowBox[{"\"\<NodeDistance\>\"", "->", "3.5"}], ",", 
    RowBox[{"\"\<StateColor\>\"", "->", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<red\>\"", ",", "\"\<blue\>\"", ",", "\"\<green\>\"", 
        ",", "\"\<orange\>\"", ",", "\"\<purple\>\"", ",", "\"\<brown\>\"", 
        ",", "\"\<pink\>\"", ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", 
        ",", "\"\<yellow\>\"", ",", "\"\<black\>\"", ",", "\"\<white\>\"", 
        ",", "\"\<gray\>\"", ",", "\"\<Red\>\"", ",", "\"\<Blue\>\"", 
        ",", "\"\<Green\>\"", ",", "\"\<Violet\>\"", ",", "\"\<Gray\>\"", 
        ",", "\"\<LightGray\>\"", ",", "\"\<Yellow\>\"", 
        ",", "\"\<Emerald\>\"", ",", "\"\<Turquoise\>\"", 
        ",", "\"\<Lavender\>\"", ",", "\"\<Peach\>\"", ",", "\"\<Salmon\>\"", 
        ",", "\"\<lightblue\>\"", ",", "\"\<lightgreen\>\"", 
        ",", "\"\<lightyellow\>\"", ",", "\"\<lightgray\>\"", 
        ",", "\"\<darkgray\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"\"\<ArrowThickness\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<TransitionColor\>\"", "->", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<red\>\"", ",", "\"\<blue\>\"", ",", "\"\<green\>\"", 
        ",", "\"\<orange\>\"", ",", "\"\<purple\>\"", ",", "\"\<brown\>\"", 
        ",", "\"\<pink\>\"", ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", 
        ",", "\"\<yellow\>\"", ",", "\"\<black\>\"", ",", "\"\<white\>\"", 
        ",", "\"\<gray\>\"", ",", "\"\<Red\>\"", ",", "\"\<Blue\>\"", 
        ",", "\"\<Green\>\"", ",", "\"\<Violet\>\"", ",", "\"\<Gray\>\"", 
        ",", "\"\<LightGray\>\"", ",", "\"\<Yellow\>\"", 
        ",", "\"\<Emerald\>\"", ",", "\"\<Turquoise\>\"", 
        ",", "\"\<Lavender\>\"", ",", "\"\<Peach\>\"", ",", "\"\<Salmon\>\"", 
        ",", "\"\<lightblue\>\"", ",", "\"\<lightgreen\>\"", 
        ",", "\"\<lightyellow\>\"", ",", "\"\<lightgray\>\"", 
        ",", "\"\<darkgray\>\""}], "}"}], "]"}]}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9671108337746058`*^9, 3.9671108347491093`*^9}, {
  3.9671110085960407`*^9, 3.9671110130454073`*^9}, {3.967111144123117*^9, 
  3.967111146940576*^9}, {3.9671114188874493`*^9, 3.967111429299376*^9}, {
  3.9671155000984697`*^9, 3.96711550041197*^9}, {3.967115651269248*^9, 
  3.9671156652554903`*^9}, {3.9671157114253798`*^9, 3.9671157527587137`*^9}, {
  3.967116007670739*^9, 3.967116014416299*^9}},
 CellLabel->"In[85]:=",ExpressionUUID->"94ae5d54-45e9-4080-b380-4b25c3f0fe84"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{"", 
       Subscript[$CellContext`\[Sigma], 5], 
       Subscript[$CellContext`\[Sigma], 0], 
       Subscript[$CellContext`\[Sigma], 1], 
       Subscript[$CellContext`\[Sigma], 6], 
       Subscript[$CellContext`\[Sigma], 2], 
       Subscript[$CellContext`\[Sigma], 3], 
       Subscript[$CellContext`\[Sigma], 4]}, {{{1, 2}, {3, 4}, {3, 5}, {3, 
       6}, {4, 3}, {4, 7}, {4, 5}, {6, 3}, {6, 6}, {6, 8}, {7, 2}, {7, 5}, {7,
        4}, {8, 5}, {8, 8}, {8, 3}, {2, 3}, {2, 7}, {2, 5}, {2, 6}, {5, 2}, {
       5, 4}, {5, 3}, {5, 5}}, Null}, {EdgeLabels -> {DirectedEdge[
           Subscript[$CellContext`\[Sigma], 1], 
           Subscript[$CellContext`\[Sigma], 3]] -> "b/4", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 6], 
           Subscript[$CellContext`\[Sigma], 5]] -> "a/6", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 0], 
           Subscript[$CellContext`\[Sigma], 1]] -> "a/0,b/3", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 0], 
           Subscript[$CellContext`\[Sigma], 6]] -> "c/1", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 2], 
           Subscript[$CellContext`\[Sigma], 4]] -> "d/0", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 3], 
           Subscript[$CellContext`\[Sigma], 6]] -> "b/4", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 1], 
           Subscript[$CellContext`\[Sigma], 0]] -> "a/5,c/6", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 5], 
           Subscript[$CellContext`\[Sigma], 6]] -> "c/0", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 2], 
           Subscript[$CellContext`\[Sigma], 0]] -> "a/3,c/2", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 3], 
           Subscript[$CellContext`\[Sigma], 5]] -> "a/6,c/6", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 6], 
           Subscript[$CellContext`\[Sigma], 6]] -> "d/6", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 3], 
           Subscript[$CellContext`\[Sigma], 1]] -> "d/0", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 2], 
           Subscript[$CellContext`\[Sigma], 2]] -> "b/0", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 5], 
           Subscript[$CellContext`\[Sigma], 3]] -> "b/0", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 6], 
           Subscript[$CellContext`\[Sigma], 1]] -> "b/0", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 5], 
           Subscript[$CellContext`\[Sigma], 0]] -> "a/2", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 4], 
           Subscript[$CellContext`\[Sigma], 6]] -> "a/2,d/3", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 4], 
           Subscript[$CellContext`\[Sigma], 4]] -> "b/6", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 1], 
           Subscript[$CellContext`\[Sigma], 6]] -> "d/2", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 4], 
           Subscript[$CellContext`\[Sigma], 0]] -> "c/1", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 0], 
           Subscript[$CellContext`\[Sigma], 2]] -> "d/2", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 6], 
           Subscript[$CellContext`\[Sigma], 0]] -> "c/0", DirectedEdge["", 
           Subscript[$CellContext`\[Sigma], 5]] -> "", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 5], 
           Subscript[$CellContext`\[Sigma], 2]] -> "d/4"}, 
       EdgeWeight -> {
        "", "a/0,b/3", "c/1", "d/2", "a/5,c/6", "b/4", "d/2", "a/3,c/2", 
         "b/0", "d/0", "a/6,c/6", "b/4", "d/0", "a/2,d/3", "b/6", "c/1", 
         "a/2", "b/0", "c/0", "d/4", "a/6", "b/0", "c/0", "d/6"}, 
       ImagePadding -> 10, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.7], Opacity[0.7], CapForm["Round"], Arrowheads[
        Medium], {
         ArrowBox[{{0., 1.0379415167229427`}, {1.3125798474382755`, 
          1.0373129068019586`}}, 0.028550376216495893`], 
         InsetBox["\<\"\"\>", {0.6562899237191377, 1.0376272117624508}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{1.3125798474382755`, 1.0373129068019586`}, {
          2.318578022780128, 1.312997952430266}}, 0.028550376216495893`], 
         InsetBox["\<\"a/2\"\>", {1.8155789351092018, 1.1751554296161122}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{1.3125798474382755`, 1.0373129068019586`}, {
           1.8611785612399347`, 1.066560679418889}, {2.3200448975421835`, 
           0.7644718408359025}}], 0.028550376216495893`], 
         InsetBox["\<\"c/0\"\>", {1.8354112471078534, 0.9714149273262043}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{1.3125798474382755`, 1.0373129068019586`}, {
          1.8341685685537386`, 2.075855129014327}}, 0.028550376216495893`], 
         InsetBox["\<\"d/4\"\>", {1.573374207996007, 1.556584017908143}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{1.3125798474382755`, 1.0373129068019586`}, {
           1.7446475970080462`, 0.6046560832128942}, {1.8355623276634199`, 
           0.}}], 0.028550376216495893`], 
         InsetBox["\<\"b/0\"\>", {1.646682991026985, 0.5552652270167395}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{2.318578022780128, 1.312997952430266}, {
           2.7315805718928003`, 0.8139307291268244}, {2.767733185943802, 
           0.16714468455977527`}}], 0.028550376216495893`], 
         InsetBox["\<\"a/0,b/3\"\>", {2.6233653331128997, 0.7715121799164779},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{2.318578022780128, 1.312997952430266}, {
           2.4095115038011845`, 1.0389761106149684`}, {2.3200448975421835`, 
           0.7644718408359025}}], 0.028550376216495893`], 
         InsetBox["\<\"c/1\"\>", {2.3577082879727618, 1.038837577866428}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{2.318578022780128, 1.312997952430266}, {
           1.9509284915554532`, 1.614769888126741}, {1.8341685685537386`, 
           2.075855129014327}}], 0.028550376216495893`], 
         InsetBox["\<\"d/2\"\>", {2.022973293306049, 1.6605178789264494}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{2.767733185943802, 0.16714468455977527`}, {
           2.354730636831132, 0.6662119078632244}, {2.318578022780128, 
           1.312997952430266}}], 0.028550376216495893`], 
         InsetBox["\<\"a/5,c/6\"\>", {2.4629458756110303, 0.7086304570735635},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{2.767733185943802, 0.16714468455977527`}, {
           2.4456641178521847`, 0.3921900660479409}, {2.3200448975421835`, 
           0.7644718408359025}}], 0.028550376216495893`], 
         InsetBox["\<\"d/2\"\>", {2.502076140803664, 0.43447008250972574}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{2.767733185943802, 0.16714468455977527`}, {
           2.3291331536203037`, -0.0697145301580655}, {1.8355623276634199`, 
           0.}}], 0.028550376216495893`], 
         InsetBox["\<\"b/4\"\>", {2.313347884722795, 0.018320382200260898}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{2.3200448975421835`, 0.7644718408359025}, {
           1.771446183740531, 0.7352240682189697}, {1.3125798474382755`, 
           1.0373129068019586`}}], 0.028550376216495893`], 
         InsetBox["\<\"a/6\"\>", {1.7972134978726055, 0.8303698203116571}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{2.3200448975421835`, 0.7644718408359025}, {
           2.2291114165211314`, 1.0384936826511983`}, {2.318578022780128, 
           1.312997952430266}}], 0.028550376216495893`], 
         InsetBox["\<\"c/0\"\>", {2.2809146323495506, 1.0386322153997405}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{2.3200448975421835`, 0.7644718408359025}, {
           2.6421139656338024`, 0.5394264593477247}, {2.767733185943802, 
           0.16714468455977527`}}], 0.028550376216495893`], 
         InsetBox["\<\"b/0\"\>", {2.585701942682322, 0.4971464428859522}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{2.3200448975421835`, 0.7644718408359025}, {
           2.5343564853237863`, 1.0062455164578097`}, {2.673448013834335, 
           1.0055655615894967`}, {2.753055074379845, 0.9561934128956332}, {
           2.788541222057914, 0.6954343991590225}, {2.7250227392731126`, 
           0.6265845952372804}, {2.5911711618776176`, 0.5887603851231021}, {
           2.3200448975421835`, 0.7644718408359025}},
           SplineDegree->7], 0.028550376216495893`], 
         InsetBox["\<\"d/6\"\>", {2.815478251558472, 0.8318943276498058}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{1.8341685685537386`, 2.075855129014327}, {
           2.201818099778411, 1.7740831933178574`}, {2.318578022780128, 
           1.312997952430266}}], 0.028550376216495893`], 
         InsetBox["\<\"a/3,c/2\"\>", {2.129773298027818, 1.728335202518144}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{1.8341685685537386`, 2.075855129014327}, {
           1.6239634314834805`, 2.0694727135768125`}, {1.4844349889722146`, 
           2.222001395213422}, {1.4801622805230659`, 2.3621086713607884`}, {
           1.816705205268498, 2.530779928749317}, {1.9263934036639587`, 
           2.4435056255456598`}, {1.9650851416835458`, 2.2404388030451696`}, {
           1.8341685685537386`, 2.075855129014327}},
           SplineDegree->7], 0.028550376216495893`], 
         InsetBox["\<\"b/0\"\>", {1.610137061050614, 2.5228561174314414}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{1.8341685685537386`, 2.075855129014327}, {
          2.767729343318762, 1.9096668909170882`}}, 0.028550376216495893`], 
         InsetBox["\<\"d/0\"\>", {2.30094895593625, 1.9927610099657076}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{1.8355623276634199`, 0.}, {1.4034945780936474`, 
           0.4326568235890704}, {1.3125798474382755`, 1.0373129068019586`}}], 
          0.028550376216495893`], 
         InsetBox["\<\"a/6,c/6\"\>", {1.5014591840747107, 0.48204767978521934},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{1.8355623276634199`, 0.}, {2.2741623599869127`, 
           0.23685921471783983`}, {2.767733185943802, 0.16714468455977527`}}],
           0.028550376216495893`], 
         InsetBox["\<\"d/0\"\>", {2.2899476288844265, 0.14882430235951435}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{1.8355623276634199`, 0.}, {2.3200448975421835`, 
          0.7644718408359025}}, 0.028550376216495893`], 
         InsetBox["\<\"b/4\"\>", {2.0778036126028017, 0.38223592041795124}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{2.767729343318762, 1.9096668909170882`}, {
          2.318578022780128, 1.312997952430266}}, 0.028550376216495893`], 
         InsetBox["\<\"c/1\"\>", {2.543153683049445, 1.611332421673677}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{2.767729343318762, 1.9096668909170882`}, {
          2.3200448975421835`, 0.7644718408359025}}, 0.028550376216495893`], 
         InsetBox["\<\"a/2,d/3\"\>", {2.5438871204304725, 1.3370693658764954},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{2.767729343318762, 1.9096668909170882`}, {
           2.751606578167686, 2.1193499644385962`}, {2.8975012538604075`, 
           2.2658010777697606`}, {3.0372596955995275`, 2.2765659665094904`}, {
           3.2213550187870066`, 1.948206338592576}, {3.139260836979401, 
           1.8345892176104566`}, {2.9382065833023914`, 1.786522887713088}, {
           2.767729343318762, 1.9096668909170882`}},
           SplineDegree->7], 0.028550376216495893`], 
         InsetBox["\<\"b/6\"\>", {3.2038611631933347, 2.154184856909146}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}}, 
       {Hue[0.6, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {DiskBox[{0., 1.0379415167229427`}, 0.028550376216495893], 
         InsetBox["\<\"\"\>", 
          Offset[{2, 2}, {0.028550376216495893, 1.0664918929394385}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.3125798474382755`, 1.0373129068019586`}, 
          0.028550376216495893], InsetBox[
          SubscriptBox["\[Sigma]", "5"], 
          Offset[{2, 2}, {1.3411302236547713, 1.0658632830184545}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.318578022780128, 1.312997952430266}, 
          0.028550376216495893], InsetBox[
          SubscriptBox["\[Sigma]", "0"], 
          Offset[{2, 2}, {2.347128398996624, 1.3415483286467618}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.767733185943802, 0.16714468455977527`}, 
          0.028550376216495893], InsetBox[
          SubscriptBox["\[Sigma]", "1"], 
          Offset[{2, 2}, {2.7962835621602977, 0.19569506077627116}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.3200448975421835`, 0.7644718408359025}, 
          0.028550376216495893], InsetBox[
          SubscriptBox["\[Sigma]", "6"], 
          Offset[{2, 2}, {2.3485952737586793, 0.7930222170523984}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8341685685537386`, 2.075855129014327}, 
          0.028550376216495893], InsetBox[
          SubscriptBox["\[Sigma]", "2"], 
          Offset[{2, 2}, {1.8627189447702344, 2.104405505230823}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8355623276634199`, 0.}, 0.028550376216495893], InsetBox[
          SubscriptBox["\[Sigma]", "3"], 
          Offset[{2, 2}, {1.8641127038799157, 0.028550376216495893}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.767729343318762, 1.9096668909170882`}, 
          0.028550376216495893], InsetBox[
          SubscriptBox["\[Sigma]", "4"], 
          Offset[{2, 2}, {2.796279719535258, 1.938217267133584}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->"NetworkGraphics",
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{{3.967115828273397*^9, 3.9671158370588408`*^9}, {
  3.967116195607896*^9, 3.9671162178250847`*^9}},
 CellLabel->"Out[86]=",ExpressionUUID->"85280e57-690f-4eb4-bb75-f640cb04bca8"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967115828278878*^9, 3.9671158370642033`*^9}, {
  3.96711619561274*^9, 3.967116217830221*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[85]:=",ExpressionUUID->"38146dd7-a109-40f8-bbc7-adc8ba5c17da"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.967115828278878*^9, 3.9671158370642033`*^9}, {
  3.96711619561274*^9, 3.9671162178314047`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[85]:=",ExpressionUUID->"85773057-7a48-473b-a008-efb097c8e1e8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967115828278878*^9, 3.9671158370642033`*^9}, {
  3.96711619561274*^9, 3.967116217831883*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[85]:=",ExpressionUUID->"c15c0634-ce9f-4e9a-9402-0e5ec9e5837e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967115828278878*^9, 3.9671158370642033`*^9}, {
  3.96711619561274*^9, 3.9671162178321857`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[85]:=",ExpressionUUID->"6a5a4eae-7038-45f5-ad18-eba4067155f8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967115828278878*^9, 3.9671158370642033`*^9}, {
  3.96711619561274*^9, 3.967116217832486*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[85]:=",ExpressionUUID->"02025bc5-a3f0-4d40-9db4-fb772d265e98"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.967115828278878*^9, 3.9671158370642033`*^9}, {
  3.96711619561274*^9, 3.967116217926078*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[85]:=",ExpressionUUID->"b94ffc88-4f68-4256-b0ad-1e3259290aff"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.967115828278878*^9, 3.9671158370642033`*^9}, {
  3.96711619561274*^9, 3.967116218933316*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[85]:=",ExpressionUUID->"4a428d8c-4f63-4969-9391-d4d93655bcf1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/maqu4/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", "/Users/enriquevilchezquesada/Downloads/maqu4/"],
  
  Editable->False]], "Print",
 CellChangeTimes->{{3.967115828278878*^9, 3.9671158370642033`*^9}, {
  3.96711619561274*^9, 3.967116218936839*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[85]:=",ExpressionUUID->"c9adb9b8-c752-48c6-808e-439f011b943e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"maqu4\"\>"}],
  SequenceForm["Archivo: ", "maqu4"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967115828278878*^9, 3.9671158370642033`*^9}, {
  3.96711619561274*^9, 3.9671162189387817`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[85]:=",ExpressionUUID->"a8881cd5-fb4a-4f70-b722-eb56fbd6aa0e"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.967115828278878*^9, 3.9671158370642033`*^9}, {
  3.96711619561274*^9, 3.9671162195263557`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[85]:=",ExpressionUUID->"931e0a96-676c-468d-9996-c3a002c05fc0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/maqu4/maqu4.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", "/Users/enriquevilchezquesada/Downloads/maqu4/maqu4.pdf"],
  
  Editable->False]], "Print",
 CellChangeTimes->{{3.967115828278878*^9, 3.9671158370642033`*^9}, {
  3.96711619561274*^9, 3.967116219526889*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[85]:=",ExpressionUUID->"be9649fa-890d-4d7f-a0e5-521243008f18"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/maqu4/maqu4.pdf\"\>"]\
, "Output",
 CellChangeTimes->{{3.967115828273397*^9, 3.9671158370588408`*^9}, {
  3.967116195607896*^9, 3.9671162195387487`*^9}},
 CellLabel->"Out[88]=",ExpressionUUID->"f2adabe0-31dd-417d-b8dc-7b62ea39c733"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 5", "Subsection",
 CellChangeTimes->{{3.967110703299527*^9, 3.9671107056555157`*^9}, 
   3.967110740365431*^9, {3.967116284663661*^9, 3.9671162875901213`*^9}, 
   3.967116357222906*^9},ExpressionUUID->"c35d7838-15c2-410a-8405-\
e6989ca0f5e4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"maqu5", "=", 
   RowBox[{
    RowBox[{"MaquinaRandom", "[", 
     RowBox[{"8", ",", "4", ",", "4", ",", 
      RowBox[{"shape", "->", "True"}], ",", 
      RowBox[{"componentes", "->", "True"}]}], "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"MaquinaToDiagrama", "[", 
  RowBox[{
   RowBox[{"maqu5", "[", 
    RowBox[{"[", "1", "]"}], "]"}], ",", 
   RowBox[{"maqu5", "[", 
    RowBox[{"[", "2", "]"}], "]"}], ",", 
   RowBox[{"maqu5", "[", 
    RowBox[{"[", "3", "]"}], "]"}], ",", 
   RowBox[{"maqu5", "[", 
    RowBox[{"[", "4", "]"}], "]"}], ",", 
   RowBox[{"maqu5", "[", 
    RowBox[{"[", "5", "]"}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportMaquinaToTikZ", "[", 
   RowBox[{
    RowBox[{"maqu5", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", 
    RowBox[{"maqu5", "[", 
     RowBox[{"[", "2", "]"}], "]"}], ",", 
    RowBox[{"maqu5", "[", 
     RowBox[{"[", "3", "]"}], "]"}], ",", 
    RowBox[{"maqu5", "[", 
     RowBox[{"[", "4", "]"}], "]"}], ",", 
    RowBox[{"maqu5", "[", 
     RowBox[{"[", "5", "]"}], "]"}], ",", "\"\<maqu5.tex\>\"", ",", 
    RowBox[{"\"\<StateSize\>\"", "->", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"{", 
       RowBox[{"0.5", ",", "2.5"}], "}"}], "]"}]}], ",", 
    RowBox[{"\"\<NodeDistance\>\"", "->", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "5"}], "}"}], "]"}]}], ",", 
    RowBox[{"\"\<ArrowThickness\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<LayoutStyle\>\"", "->", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<circular\>\"", ",", "\"\<grid\>\"", 
        ",", "\"\<spring\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"\"\<AutoColor\>\"", "->", "True"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.9671107146963873`*^9, {3.967110747153029*^9, 3.9671107683928022`*^9}, {
   3.967110838752563*^9, 3.967110840496626*^9}, {3.9671109182889767`*^9, 
   3.9671109758166428`*^9}, {3.9671110167387*^9, 3.967111018777968*^9}, {
   3.967111150379092*^9, 3.967111153558546*^9}, {3.9671114333951883`*^9, 
   3.96711144317946*^9}, 3.967115509823798*^9, {3.9671156689011917`*^9, 
   3.967115701189301*^9}, {3.96711586044906*^9, 3.967115885500576*^9}, {
   3.967115932531164*^9, 3.96711595011967*^9}, 3.967115993878386*^9, {
   3.967116048712264*^9, 3.967116089339303*^9}, 3.967116259853489*^9, {
   3.9671162906210413`*^9, 3.96711629458003*^9}, 3.96711632947519*^9, 
   3.9671163597505217`*^9},
 CellLabel->
  "In[133]:=",ExpressionUUID->"e4be93f8-0633-49e5-99cc-7d3eb171883e"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{"", 
       Subscript[$CellContext`\[Sigma], 0], 
       Subscript[$CellContext`\[Sigma], 3], 
       Subscript[$CellContext`\[Sigma], 4], 
       Subscript[$CellContext`\[Sigma], 7], 
       Subscript[$CellContext`\[Sigma], 1], 
       Subscript[$CellContext`\[Sigma], 5], 
       Subscript[$CellContext`\[Sigma], 2], 
       Subscript[$CellContext`\[Sigma], 6]}, {{{1, 2}, {2, 2}, {2, 3}, {2, 
       4}, {2, 5}, {6, 7}, {6, 6}, {6, 4}, {6, 5}, {8, 7}, {8, 2}, {8, 3}, {8,
        5}, {3, 3}, {3, 7}, {3, 5}, {3, 6}, {4, 7}, {4, 4}, {4, 6}, {4, 9}, {
       7, 4}, {7, 9}, {7, 2}, {7, 5}, {9, 3}, {9, 2}, {5, 7}, {5, 6}, {5, 
       9}, {5, 2}}, Null}, {EdgeLabels -> {DirectedEdge[
           Subscript[$CellContext`\[Sigma], 2], 
           Subscript[$CellContext`\[Sigma], 0]] -> "b/2", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 5], 
           Subscript[$CellContext`\[Sigma], 4]] -> "a/1", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 1], 
           Subscript[$CellContext`\[Sigma], 7]] -> "d/3", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 6], 
           Subscript[$CellContext`\[Sigma], 0]] -> "d/0", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 3], 
           Subscript[$CellContext`\[Sigma], 1]] -> "d/3", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 0], 
           Subscript[$CellContext`\[Sigma], 7]] -> "d/0", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 4], 
           Subscript[$CellContext`\[Sigma], 6]] -> "d/0", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 6], 
           Subscript[$CellContext`\[Sigma], 3]] -> "a/0,b/1,c/1", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 4], 
           Subscript[$CellContext`\[Sigma], 4]] -> "b/2", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 2], 
           Subscript[$CellContext`\[Sigma], 7]] -> "d/0", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 0], 
           Subscript[$CellContext`\[Sigma], 3]] -> "b/3", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 0], 
           Subscript[$CellContext`\[Sigma], 4]] -> "c/2", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 7], 
           Subscript[$CellContext`\[Sigma], 6]] -> "c/1", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 7], 
           Subscript[$CellContext`\[Sigma], 0]] -> "d/0", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 3], 
           Subscript[$CellContext`\[Sigma], 7]] -> "c/1", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 3], 
           Subscript[$CellContext`\[Sigma], 5]] -> "b/3", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 1], 
           Subscript[$CellContext`\[Sigma], 5]] -> "a/0", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 1], 
           Subscript[$CellContext`\[Sigma], 1]] -> "b/2", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 4], 
           Subscript[$CellContext`\[Sigma], 5]] -> "a/0", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 7], 
           Subscript[$CellContext`\[Sigma], 5]] -> "a/0", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 4], 
           Subscript[$CellContext`\[Sigma], 1]] -> "c/1", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 3], 
           Subscript[$CellContext`\[Sigma], 3]] -> "a/2", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 5], 
           Subscript[$CellContext`\[Sigma], 7]] -> "d/2", DirectedEdge["", 
           Subscript[$CellContext`\[Sigma], 0]] -> "", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 7], 
           Subscript[$CellContext`\[Sigma], 1]] -> "b/3", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 1], 
           Subscript[$CellContext`\[Sigma], 4]] -> "c/3", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 5], 
           Subscript[$CellContext`\[Sigma], 0]] -> "c/2", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 2], 
           Subscript[$CellContext`\[Sigma], 3]] -> "c/1", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 0], 
           Subscript[$CellContext`\[Sigma], 0]] -> "a/1", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 2], 
           Subscript[$CellContext`\[Sigma], 5]] -> "a/3", DirectedEdge[
           Subscript[$CellContext`\[Sigma], 5], 
           Subscript[$CellContext`\[Sigma], 6]] -> "b/3"}, 
       EdgeWeight -> {
        "", "a/1", "b/3", "c/2", "d/0", "a/0", "b/2", "c/3", "d/3", "a/3", 
         "b/2", "c/1", "d/0", "a/2", "b/3", "c/1", "d/3", "a/0", "b/2", "c/1",
          "d/0", "a/1", "b/3", "c/2", "d/2", "a/0,b/1,c/1", "d/0", "a/0", 
         "b/3", "c/1", "d/0"}, ImagePadding -> 10, 
       VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.7], Opacity[0.7], CapForm["Round"], Arrowheads[
        Medium], {
         ArrowBox[{{0., 1.265174459819301}, {1.5025301515602911`, 
          1.0647857417244784`}}, 0.032521160118441764`], 
         InsetBox["\<\"\"\>", {0.7512650757801456, 1.1649801007718898}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{1.5025301515602911`, 1.0647857417244784`}, {
           1.226888522119155, 1.2184917434846596`}, {1.197441176434333, 
           1.3602326299948215`}, {1.2314228711861213`, 1.4516554504795958`}, {
           1.4910423824540604`, 1.5370519380429424`}, {1.5726601511971916`, 
           1.4836531786099023`}, {1.6331045773092174`, 1.352108142867173}, {
           1.5025301515602911`, 1.0647857417244784`}},
           SplineDegree->7], 0.032521160118441764`], 
         InsetBox["\<\"a/1\"\>", {1.3463000623928774, 1.5397511712440826}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{1.5025301515602911`, 1.0647857417244784`}, {
          2.1471625846601805`, 0.6370774458128883}}, 0.032521160118441764`], 
         InsetBox["\<\"b/3\"\>", {1.8248463681102358, 0.8509315937686833}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{1.5025301515602911`, 1.0647857417244784`}, {
          2.6279943153737353`, 1.9705154921232002`}}, 0.032521160118441764`], 
         InsetBox["\<\"c/2\"\>", {2.0652622334670134, 1.5176506169238393}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{1.5025301515602911`, 1.0647857417244784`}, {
           2.1646130460545394`, 0.9464085680463669}, {2.6271856611211697`, 
           0.45815300973665074`}}], 0.032521160118441764`], 
         InsetBox["\<\"d/0\"\>", {2.1073221975798786, 0.8401952613998263}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{2.1471625846601805`, 0.6370774458128883}, {
           1.9179020782361595`, 0.37199213354489785`}, {1.8003947925989214`, 
           0.36775970670032987`}, {1.7301426898486125`, 
           0.40407474460745313`}, {1.669772991217406, 0.6199010809406862}, {
           1.710988218027274, 0.6873951176998465}, {1.8136381326283009`, 
           0.744743793771993}, {2.1471625846601805`, 0.6370774458128883}},
           SplineDegree->7], 0.032521160118441764`], 
         InsetBox["\<\"a/2\"\>", {1.6656448645117865, 0.5023900849244475}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{2.1471625846601805`, 0.6370774458128883}, {
          2.6271856611211697`, 0.45815300973665074`}}, 0.032521160118441764`],
          InsetBox["\<\"c/1\"\>", {2.3871741228906753, 0.5476152277747695}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{2.1471625846601805`, 0.6370774458128883}, {
          3.3243424434255004`, 1.1103035928606229`}}, 0.032521160118441764`], 
         InsetBox["\<\"d/3\"\>", {2.7357525140428405, 0.8736905193367556}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{2.1471625846601805`, 0.6370774458128883}, {
          2.508574262482555, 1.0884549548510987`}}, 0.032521160118441764`], 
         InsetBox["\<\"b/3\"\>", {2.327868423571368, 0.8627662003319935}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{2.6279943153737353`, 1.9705154921232002`}, {
           2.4527671873846644`, 2.086801297337099}, {2.4270631843679964`, 
           2.2919170920003595`}, {2.5045555175755574`, 2.408721386274903}, {
           2.87668035716119, 2.351851033466046}, {2.915748852905196, 
           2.2172332132964025`}, {2.829954916954067, 2.0291572032753598`}, {
           2.6279943153737353`, 1.9705154921232002`}},
           SplineDegree->7], 0.032521160118441764`], 
         InsetBox["\<\"b/2\"\>", {2.703530308104583, 2.4647768741895777}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{2.6279943153737353`, 1.9705154921232002`}, {
           3.117622266850167, 1.654917548968295}, {3.3243424434255004`, 
           1.1103035928606229`}}], 0.032521160118441764`], 
         InsetBox["\<\"c/1\"\>", {3.0363832123479986, 1.5891539114555353}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{2.6279943153737353`, 1.9705154921232002`}, {
           2.71333098273792, 1.5098477007610616`}, {2.508574262482555, 
           1.0884549548510987`}}], 0.032521160118441764`], 
         InsetBox["\<\"a/0\"\>", {2.6300285265371928, 1.5211258197847668}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{2.6279943153737353`, 1.9705154921232002`}, {
          2.024584033413851, 1.5691329848648465`}}, 0.032521160118441764`], 
         InsetBox["\<\"d/0\"\>", {2.3262891743937932, 1.7698242384940235}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{2.6271856611211697`, 0.45815300973665074`}, {
           1.965102766626927, 0.5765301834147613}, {1.5025301515602911`, 
           1.0647857417244784`}}], 0.032521160118441764`], 
         InsetBox["\<\"d/0\"\>", {2.0223936151015827, 0.682743490061303}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{2.6271856611211697`, 0.45815300973665074`}, {
           2.8685239231085236`, 0.8988692834845474}, {3.3243424434255004`, 
           1.1103035928606229`}}], 0.032521160118441764`], 
         InsetBox["\<\"b/3\"\>", {2.930113511454657, 0.8330292760599399}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{2.6271856611211697`, 0.45815300973665074`}, {
           2.4642326389962883`, 0.7537994352772873}, {2.508574262482555, 
           1.0884549548510987`}}], 0.032521160118441764`], 
         InsetBox["\<\"a/0\"\>", {2.523758825643851, 0.7650011843891718}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{2.6271856611211697`, 0.45815300973665074`}, {
          2.024584033413851, 1.5691329848648465`}}, 0.032521160118441764`], 
         InsetBox["\<\"c/1\"\>", {2.3258848472675107, 1.0136429973007486}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{3.3243424434255004`, 1.1103035928606229`}, {
           2.8347144919490908`, 1.4259015360154919`}, {2.6279943153737353`, 
           1.9705154921232002`}}], 0.032521160118441764`], 
         InsetBox["\<\"c/3\"\>", {2.9159535464512376, 1.4916651735282882}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{3.3243424434255004`, 1.1103035928606229`}, {
           3.083004181438131, 0.6695873191127184}, {2.6271856611211697`, 
           0.45815300973665074`}}], 0.032521160118441764`], 
         InsetBox["\<\"d/3\"\>", {3.0214145930920133, 0.7354273265373334}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{3.3243424434255004`, 1.1103035928606229`}, {
           3.425785905547049, 1.2945212870985456`}, {3.628084272855754, 
           1.3370484028678329`}, {3.750879724873147, 1.2694497207004283`}, {
           3.724882529611311, 0.8939030803163679}, {3.5939439645635978`, 
           0.8438691213467684}, {3.399435009254011, 0.9138652019212912}, {
           3.3243424434255004`, 1.1103035928606229`}},
           SplineDegree->7], 0.032521160118441764`], 
         InsetBox["\<\"b/2\"\>", {3.8231487088532514, 1.0757737569209616}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{3.3243424434255004`, 1.1103035928606229`}, {
          2.508574262482555, 1.0884549548510987`}}, 0.032521160118441764`], 
         InsetBox["\<\"a/0\"\>", {2.9164583529540278, 1.0993792738558608}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{2.508574262482555, 1.0884549548510987`}, {
          1.5025301515602911`, 1.0647857417244784`}}, 0.032521160118441764`], 
         InsetBox["\<\"c/2\"\>", {2.005552207021423, 1.0766203482877885}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{2.508574262482555, 1.0884549548510987`}, {
           2.4232375951183815`, 1.5491227462132084`}, {2.6279943153737353`, 
           1.9705154921232002`}}], 0.032521160118441764`], 
         InsetBox["\<\"a/1\"\>", {2.5065400513190985, 1.537844627189532}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[
          BezierCurveBox[{{2.508574262482555, 1.0884549548510987`}, {
           2.671527284607456, 0.7928085293104711}, {2.6271856611211697`, 
           0.45815300973665074`}}], 0.032521160118441764`], 
         InsetBox["\<\"d/2\"\>", {2.6120010979598742, 0.7816067801985778}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{2.508574262482555, 1.0884549548510987`}, {
          2.024584033413851, 1.5691329848648465`}}, 0.032521160118441764`], 
         InsetBox["\<\"b/3\"\>", {2.266579147948203, 1.3287939698579727}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{1.847622076744637, 0.}, {1.5025301515602911`, 
          1.0647857417244784`}}, 0.032521160118441764`], 
         InsetBox["\<\"b/2\"\>", {1.6750761141524642, 0.5323928708622392}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{1.847622076744637, 0.}, {2.1471625846601805`, 
          0.6370774458128883}}, 0.032521160118441764`], 
         InsetBox["\<\"c/1\"\>", {1.9973923307024086, 0.31853872290644414}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{1.847622076744637, 0.}, {2.6271856611211697`, 
          0.45815300973665074`}}, 0.032521160118441764`], 
         InsetBox["\<\"d/0\"\>", {2.2374038689329034, 0.22907650486832537}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{1.847622076744637, 0.}, {2.508574262482555, 
          1.0884549548510987`}}, 0.032521160118441764`], 
         InsetBox["\<\"a/3\"\>", {2.178098169613596, 0.5442274774255493}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{2.024584033413851, 1.5691329848648465`}, {
          1.5025301515602911`, 1.0647857417244784`}}, 0.032521160118441764`], 
         InsetBox["\<\"d/0\"\>", {1.7635570924870712, 1.3169593632946626}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{2.024584033413851, 1.5691329848648465`}, {
          2.1471625846601805`, 0.6370774458128883}}, 0.032521160118441764`], 
         InsetBox["\<\"a/0,b/1,c/1\"\>", {2.085873309037016, 1.1031052153388674},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}}, 
       {Hue[0.6, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {DiskBox[{0., 1.265174459819301}, 0.032521160118441764], 
         InsetBox["\<\"\"\>", 
          Offset[{2, 2}, {0.032521160118441764, 1.297695619937743}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.5025301515602911`, 1.0647857417244784`}, 
          0.032521160118441764], InsetBox[
          SubscriptBox["\[Sigma]", "0"], 
          Offset[{2, 2}, {1.535051311678733, 1.0973069018429202}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.1471625846601805`, 0.6370774458128883}, 
          0.032521160118441764], InsetBox[
          SubscriptBox["\[Sigma]", "3"], 
          Offset[{2, 2}, {2.179683744778622, 0.66959860593133}], ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.6279943153737353`, 1.9705154921232002`}, 
          0.032521160118441764], InsetBox[
          SubscriptBox["\[Sigma]", "4"], 
          Offset[{2, 2}, {2.660515475492177, 2.003036652241642}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.6271856611211697`, 0.45815300973665074`}, 
          0.032521160118441764], InsetBox[
          SubscriptBox["\[Sigma]", "7"], 
          Offset[{2, 2}, {2.6597068212396113, 0.4906741698550925}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.3243424434255004`, 1.1103035928606229`}, 
          0.032521160118441764], InsetBox[
          SubscriptBox["\[Sigma]", "1"], 
          Offset[{2, 2}, {3.356863603543942, 1.1428247529790647}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.508574262482555, 1.0884549548510987`}, 
          0.032521160118441764], InsetBox[
          SubscriptBox["\[Sigma]", "5"], 
          Offset[{2, 2}, {2.5410954226009967, 1.1209761149695405}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.847622076744637, 0.}, 0.032521160118441764], InsetBox[
          SubscriptBox["\[Sigma]", "2"], 
          Offset[{2, 2}, {1.8801432368630788, 0.032521160118441764}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.024584033413851, 1.5691329848648465`}, 
          0.032521160118441764], InsetBox[
          SubscriptBox["\[Sigma]", "6"], 
          Offset[{2, 2}, {2.057105193532293, 1.6016541449832884}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->"NetworkGraphics",
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{{3.967116244903287*^9, 3.967116360648247*^9}, 
   3.967116390673031*^9},
 CellLabel->
  "Out[134]=",ExpressionUUID->"235d61dc-086b-451a-aba1-3b6a71b58458"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9671162449311867`*^9, 3.967116360655468*^9}, 
   3.967116390678812*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[133]:=",ExpressionUUID->"8bb514f6-d9d1-44ef-a553-9a3728aabcd4"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.9671162449311867`*^9, 3.967116360655468*^9}, 
   3.967116390680195*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[133]:=",ExpressionUUID->"127197c9-3b78-4670-a985-b358249f5c35"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9671162449311867`*^9, 3.967116360655468*^9}, 
   3.967116390680661*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[133]:=",ExpressionUUID->"99c59911-0b7a-4798-aa2b-5c4734508c44"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9671162449311867`*^9, 3.967116360655468*^9}, 
   3.967116390680983*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[133]:=",ExpressionUUID->"e5177cbc-72ac-4727-adc5-b31772f6bd8c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9671162449311867`*^9, 3.967116360655468*^9}, 
   3.967116390681301*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[133]:=",ExpressionUUID->"48289630-bdce-4e61-a7eb-1aef2a23500e"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.9671162449311867`*^9, 3.967116360655468*^9}, 
   3.967116390772008*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[133]:=",ExpressionUUID->"499cf310-e738-4e34-bef8-b0e520b19171"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.9671162449311867`*^9, 3.967116360655468*^9}, 
   3.967116391776671*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[133]:=",ExpressionUUID->"bef3d88c-20d8-4775-91b3-3063255bc8e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/maqu5/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", "/Users/enriquevilchezquesada/Downloads/maqu5/"],
  
  Editable->False]], "Print",
 CellChangeTimes->{{3.9671162449311867`*^9, 3.967116360655468*^9}, 
   3.96711639177739*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[133]:=",ExpressionUUID->"7dbf80e0-99d8-481b-82b8-c2e9ec15cb7c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"maqu5\"\>"}],
  SequenceForm["Archivo: ", "maqu5"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9671162449311867`*^9, 3.967116360655468*^9}, 
   3.967116391777761*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[133]:=",ExpressionUUID->"b5307e15-028a-4d88-a199-cd595072154f"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.9671162449311867`*^9, 3.967116360655468*^9}, 
   3.967116392365122*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[133]:=",ExpressionUUID->"696058dd-6a46-4f04-bcde-6a5151cb3821"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/maqu5/maqu5.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", "/Users/enriquevilchezquesada/Downloads/maqu5/maqu5.pdf"],
  
  Editable->False]], "Print",
 CellChangeTimes->{{3.9671162449311867`*^9, 3.967116360655468*^9}, 
   3.967116392365807*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[133]:=",ExpressionUUID->"1aa4cecd-48b6-473a-89cd-bb57134ffc99"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/maqu5/maqu5.pdf\"\>"]\
, "Output",
 CellChangeTimes->{{3.967116244903287*^9, 3.967116360648247*^9}, 
   3.967116392381803*^9},
 CellLabel->
  "Out[136]=",ExpressionUUID->"cdad8053-5eb7-4374-bc20-bde382e8eb71"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1235, 688},
WindowMargins->{{161, Automatic}, {Automatic, 0}},
FrontEndVersion->"14.3 para Mac OS X ARM (64-bit) (July 8, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"5420f22d-720b-4572-84cb-8f050efca9fa"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[576, 22, 280, 5, 99, "Input",ExpressionUUID->"36c03ecc-2c5c-45b5-8910-1c9922179926"],
Cell[CellGroupData[{
Cell[881, 31, 1052, 31, 86, "Print",ExpressionUUID->"970d2ba0-abc1-4e40-b568-46f09221b3ba"],
Cell[1936, 64, 276, 5, 46, "Print",ExpressionUUID->"a006985d-01f4-423e-b6cd-6bb476f222aa"],
Cell[2215, 71, 274, 5, 46, "Print",ExpressionUUID->"0f374020-1180-49f5-bc96-17cf84641d22"],
Cell[2492, 78, 517, 11, 46, "Print",ExpressionUUID->"76c5e5dd-5550-48fd-918b-40f74bc0355c"],
Cell[3012, 91, 554, 12, 46, "Print",ExpressionUUID->"c3cecd12-8d16-486e-8950-4d42d2ce7740"],
Cell[3569, 105, 520, 11, 46, "Print",ExpressionUUID->"9d27b222-0ead-4516-abf9-99b0ed7178d3"],
Cell[4092, 118, 519, 11, 46, "Print",ExpressionUUID->"32a117ac-d871-4a54-828e-655c97c26a07"],
Cell[4614, 131, 1053, 31, 86, "Print",ExpressionUUID->"1899efea-2a93-46e2-aa96-d11cffaab766"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5716, 168, 432, 6, 136, "Subtitle",ExpressionUUID->"e620c90a-a47e-4279-8a06-c63909917048"],
Cell[CellGroupData[{
Cell[6173, 178, 206, 3, 58, "Input",ExpressionUUID->"d514a4a3-d557-4ff2-84f4-b4dd4756d43d"],
Cell[6382, 183, 163268, 3148, 5670, "Output",ExpressionUUID->"63f8a97a-1bb9-40a3-a89a-2fb06b38759c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[169687, 3336, 159, 3, 106, "Subsection",ExpressionUUID->"4097ae79-971c-4c28-bf03-96b89163b705"],
Cell[CellGroupData[{
Cell[169871, 3343, 2314, 54, 475, "Input",ExpressionUUID->"7e4a6b0f-20c1-4546-84c2-f8838fb39b6e"],
Cell[172188, 3399, 9163, 172, 641, "Output",ExpressionUUID->"e7fcdd3d-f2c3-4760-9022-82c7f545d7c6"],
Cell[CellGroupData[{
Cell[181376, 3575, 1328, 22, 46, "Print",ExpressionUUID->"975537a7-0595-4f27-ab8b-abadfaec27bd"],
Cell[182707, 3599, 1118, 17, 46, "Print",ExpressionUUID->"a27f352b-2803-47f3-a2a6-4e43d94c39a1"],
Cell[183828, 3618, 1313, 22, 46, "Print",ExpressionUUID->"e65e6143-0d41-4d59-9bf0-7753f844f421"],
Cell[185144, 3642, 1338, 22, 46, "Print",ExpressionUUID->"e1a131cf-40ce-4d86-8eeb-31d4868d8aad"],
Cell[186485, 3666, 1318, 23, 46, "Print",ExpressionUUID->"ea7ab197-9577-488b-8f41-a11701ff3694"],
Cell[187806, 3691, 1125, 17, 46, "Print",ExpressionUUID->"aa01e4b7-6038-40e8-8ad7-a940e53bb35d"],
Cell[188934, 3710, 1130, 17, 46, "Print",ExpressionUUID->"0679660b-003b-467f-9ad8-7b9d718bd3e9"],
Cell[190067, 3729, 1357, 25, 46, "Print",ExpressionUUID->"475d3537-dd55-47ad-929d-71637e86320e"],
Cell[191427, 3756, 1239, 21, 46, "Print",ExpressionUUID->"90c2404a-00da-41bf-97ac-7339d349ed5f"],
Cell[192669, 3779, 1128, 17, 46, "Print",ExpressionUUID->"e0fd7337-bc47-4609-9665-58571ddf2716"],
Cell[193800, 3798, 1359, 25, 46, "Print",ExpressionUUID->"ecda08bc-c6df-43a4-b78c-59bfc52a9000"]
}, Open  ]],
Cell[195174, 3826, 1117, 16, 66, "Output",ExpressionUUID->"5d05a7ce-8189-4698-b9b0-8562997fbce7"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[196340, 3848, 157, 3, 106, "Subsection",ExpressionUUID->"390ce748-d4b2-4ade-a3d4-38dca5cf99b1"],
Cell[CellGroupData[{
Cell[196522, 3855, 2204, 51, 475, "Input",ExpressionUUID->"d55d9e0a-f9de-4b71-ba35-946b80402343"],
Cell[198729, 3908, 8647, 164, 308, "Output",ExpressionUUID->"0bb30d84-c786-4f95-8032-d68a20e2b3aa"],
Cell[CellGroupData[{
Cell[207401, 4076, 472, 10, 46, "Print",ExpressionUUID->"bdffef4d-3922-44e3-855e-50be17df62f1"],
Cell[207876, 4088, 263, 5, 46, "Print",ExpressionUUID->"042befec-6cb4-4da5-bb0f-2cec39342f14"],
Cell[208142, 4095, 455, 10, 46, "Print",ExpressionUUID->"9fffa307-5759-4d28-941b-2dcff3739f51"],
Cell[208600, 4107, 482, 10, 46, "Print",ExpressionUUID->"5a42f3e7-618c-40d8-8229-09c0dc178477"],
Cell[209085, 4119, 462, 11, 46, "Print",ExpressionUUID->"f7b3c77d-d9bd-4eed-8bf4-89771b444ff9"],
Cell[209550, 4132, 270, 5, 46, "Print",ExpressionUUID->"679b5a42-cb08-43fd-99cf-2eb6990a5ab1"],
Cell[209823, 4139, 272, 5, 46, "Print",ExpressionUUID->"192c72ae-c2d4-4915-9d5a-6bb25dd1b317"],
Cell[210098, 4146, 501, 13, 46, "Print",ExpressionUUID->"73bd51da-90b9-4c8b-a42f-a3d9fba3bd83"],
Cell[210602, 4161, 381, 9, 46, "Print",ExpressionUUID->"093b8562-6a10-4c8f-b02b-d89e35abfbf0"],
Cell[210986, 4172, 272, 5, 46, "Print",ExpressionUUID->"712a2e15-aa77-46a7-9c1a-c3ae57014a8d"],
Cell[211261, 4179, 501, 13, 46, "Print",ExpressionUUID->"85491409-31be-4ee7-864d-8827f8088424"]
}, Open  ]],
Cell[211777, 4195, 261, 4, 66, "Output",ExpressionUUID->"89c8e2d1-18aa-486d-85d7-b0f56b64b79b"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[212087, 4205, 182, 3, 106, "Subsection",ExpressionUUID->"a0dbba57-230a-4afc-9f8e-6a67ecf8d84e"],
Cell[CellGroupData[{
Cell[212294, 4212, 3883, 78, 995, "Input",ExpressionUUID->"44c00615-09be-496f-b244-b16c60c7b6eb"],
Cell[216180, 4292, 10357, 193, 487, "Output",ExpressionUUID->"d92f4756-d395-4c45-bced-718f7cdabf33"],
Cell[CellGroupData[{
Cell[226562, 4489, 493, 10, 46, "Print",ExpressionUUID->"576691be-7827-49ed-8de5-ae1bcf75d19e"],
Cell[227058, 4501, 286, 5, 46, "Print",ExpressionUUID->"83fdbbe7-f01a-4e72-8d40-9ae5dd43bd95"],
Cell[227347, 4508, 478, 10, 46, "Print",ExpressionUUID->"1295bcff-fa8f-4ffa-a3db-c8eed4655e94"],
Cell[227828, 4520, 505, 10, 46, "Print",ExpressionUUID->"8174fedb-15e6-4cae-9e68-7176d02fd4aa"],
Cell[228336, 4532, 485, 11, 46, "Print",ExpressionUUID->"a15cfaa4-6bb5-4287-af5f-081ecaceea76"],
Cell[228824, 4545, 294, 5, 46, "Print",ExpressionUUID->"5529631c-b6d7-4a72-b037-101671f61b53"],
Cell[229121, 4552, 295, 5, 46, "Print",ExpressionUUID->"446bcb30-c96e-49dd-98e5-fc8cf04aa7f3"],
Cell[229419, 4559, 526, 13, 46, "Print",ExpressionUUID->"f52a6e6f-ba73-4f65-b00b-ef5ffe16952a"],
Cell[229948, 4574, 404, 9, 46, "Print",ExpressionUUID->"29ea552a-1324-4793-a5a9-9cb8e4f63ccc"],
Cell[230355, 4585, 293, 5, 46, "Print",ExpressionUUID->"f15640ab-9ddb-4237-a214-c3412927fc77"],
Cell[230651, 4592, 524, 13, 46, "Print",ExpressionUUID->"0d5414ac-8502-44be-ac87-52be97323ffe"]
}, Open  ]],
Cell[231190, 4608, 287, 4, 66, "Output",ExpressionUUID->"2f8f9acc-44a2-46cb-b358-ce0c0fc5487e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[231526, 4618, 184, 3, 106, "Subsection",ExpressionUUID->"a60a9292-b7c2-4e4d-9c1e-1e771e6ef1da"],
Cell[CellGroupData[{
Cell[231735, 4625, 3821, 76, 995, "Input",ExpressionUUID->"94ae5d54-45e9-4080-b380-4b25c3f0fe84"],
Cell[235559, 4703, 15722, 291, 615, "Output",ExpressionUUID->"85280e57-690f-4eb4-bb75-f640cb04bca8"],
Cell[CellGroupData[{
Cell[251306, 4998, 496, 10, 46, "Print",ExpressionUUID->"38146dd7-a109-40f8-bbc7-adc8ba5c17da"],
Cell[251805, 5010, 289, 5, 46, "Print",ExpressionUUID->"85773057-7a48-473b-a008-efb097c8e1e8"],
Cell[252097, 5017, 479, 10, 46, "Print",ExpressionUUID->"c15c0634-ce9f-4e9a-9402-0e5ec9e5837e"],
Cell[252579, 5029, 508, 10, 46, "Print",ExpressionUUID->"6a5a4eae-7038-45f5-ad18-eba4067155f8"],
Cell[253090, 5041, 486, 11, 46, "Print",ExpressionUUID->"02025bc5-a3f0-4d40-9db4-fb772d265e98"],
Cell[253579, 5054, 295, 5, 46, "Print",ExpressionUUID->"b94ffc88-4f68-4256-b0ad-1e3259290aff"],
Cell[253877, 5061, 296, 5, 46, "Print",ExpressionUUID->"4a428d8c-4f63-4969-9391-d4d93655bcf1"],
Cell[254176, 5068, 525, 13, 46, "Print",ExpressionUUID->"c9adb9b8-c752-48c6-808e-439f011b943e"],
Cell[254704, 5083, 407, 9, 46, "Print",ExpressionUUID->"a8881cd5-fb4a-4f70-b722-eb56fbd6aa0e"],
Cell[255114, 5094, 296, 5, 46, "Print",ExpressionUUID->"931e0a96-676c-468d-9996-c3a002c05fc0"],
Cell[255413, 5101, 525, 13, 46, "Print",ExpressionUUID->"be9649fa-890d-4d7f-a0e5-521243008f18"]
}, Open  ]],
Cell[255953, 5117, 289, 4, 66, "Output",ExpressionUUID->"f2adabe0-31dd-417d-b8dc-7b62ea39c733"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[256291, 5127, 256, 4, 106, "Subsection",ExpressionUUID->"c35d7838-15c2-410a-8405-e6989ca0f5e4"],
Cell[CellGroupData[{
Cell[256572, 5135, 2784, 65, 535, "Input",ExpressionUUID->"e4be93f8-0633-49e5-99cc-7d3eb171883e"],
Cell[259359, 5202, 19062, 347, 522, "Output",ExpressionUUID->"235d61dc-086b-451a-aba1-3b6a71b58458"],
Cell[CellGroupData[{
Cell[278446, 5553, 475, 10, 46, "Print",ExpressionUUID->"8bb514f6-d9d1-44ef-a553-9a3728aabcd4"],
Cell[278924, 5565, 266, 5, 46, "Print",ExpressionUUID->"127197c9-3b78-4670-a985-b358249f5c35"],
Cell[279193, 5572, 458, 10, 46, "Print",ExpressionUUID->"99c59911-0b7a-4798-aa2b-5c4734508c44"],
Cell[279654, 5584, 485, 10, 46, "Print",ExpressionUUID->"e5177cbc-72ac-4727-adc5-b31772f6bd8c"],
Cell[280142, 5596, 465, 11, 46, "Print",ExpressionUUID->"48289630-bdce-4e61-a7eb-1aef2a23500e"],
Cell[280610, 5609, 274, 5, 46, "Print",ExpressionUUID->"499cf310-e738-4e34-bef8-b0e520b19171"],
Cell[280887, 5616, 275, 5, 46, "Print",ExpressionUUID->"bef3d88c-20d8-4775-91b3-3063255bc8e3"],
Cell[281165, 5623, 503, 13, 46, "Print",ExpressionUUID->"7dbf80e0-99d8-481b-82b8-c2e9ec15cb7c"],
Cell[281671, 5638, 384, 9, 46, "Print",ExpressionUUID->"b5307e15-028a-4d88-a199-cd595072154f"],
Cell[282058, 5649, 273, 5, 46, "Print",ExpressionUUID->"696058dd-6a46-4f04-bcde-6a5151cb3821"],
Cell[282334, 5656, 504, 13, 46, "Print",ExpressionUUID->"1aa4cecd-48b6-473a-89cd-bb57134ffc99"]
}, Open  ]],
Cell[282853, 5672, 266, 5, 66, "Output",ExpressionUUID->"cdad8053-5eb7-4374-bc20-bde382e8eb71"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

